<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_AdditionalPolicy StructType
 * @subpackage Structs
 */
class JP_AdditionalPolicy extends AbstractStructBase
{
    /**
     * The Allowed
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Allowed;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The PolicyRules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Rule
     */
    public $PolicyRules;
    /**
     * The PolicyType
     * @var string
     */
    public $PolicyType;
    /**
     * The PassengerType
     * @var string
     */
    public $PassengerType;
    /**
     * Constructor method for JP_AdditionalPolicy
     * @uses JP_AdditionalPolicy::setAllowed()
     * @uses JP_AdditionalPolicy::setDescription()
     * @uses JP_AdditionalPolicy::setPolicyRules()
     * @uses JP_AdditionalPolicy::setPolicyType()
     * @uses JP_AdditionalPolicy::setPassengerType()
     * @param bool $allowed
     * @param string $description
     * @param \ArrayType\ArrayOfJP_Rule $policyRules
     * @param string $policyType
     * @param string $passengerType
     */
    public function __construct($allowed = null, $description = null, \ArrayType\ArrayOfJP_Rule $policyRules = null, $policyType = null, $passengerType = null)
    {
        $this
            ->setAllowed($allowed)
            ->setDescription($description)
            ->setPolicyRules($policyRules)
            ->setPolicyType($policyType)
            ->setPassengerType($passengerType);
    }
    /**
     * Get Allowed value
     * @return bool
     */
    public function getAllowed()
    {
        return $this->Allowed;
    }
    /**
     * Set Allowed value
     * @param bool $allowed
     * @return \StructType\JP_AdditionalPolicy
     */
    public function setAllowed($allowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowed) && !is_bool($allowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowed, true), gettype($allowed)), __LINE__);
        }
        $this->Allowed = $allowed;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\JP_AdditionalPolicy
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get PolicyRules value
     * @return \ArrayType\ArrayOfJP_Rule|null
     */
    public function getPolicyRules()
    {
        return $this->PolicyRules;
    }
    /**
     * Set PolicyRules value
     * @param \ArrayType\ArrayOfJP_Rule $policyRules
     * @return \StructType\JP_AdditionalPolicy
     */
    public function setPolicyRules(\ArrayType\ArrayOfJP_Rule $policyRules = null)
    {
        $this->PolicyRules = $policyRules;
        return $this;
    }
    /**
     * Get PolicyType value
     * @return string|null
     */
    public function getPolicyType()
    {
        return $this->PolicyType;
    }
    /**
     * Set PolicyType value
     * @param string $policyType
     * @return \StructType\JP_AdditionalPolicy
     */
    public function setPolicyType($policyType = null)
    {
        // validation for constraint: string
        if (!is_null($policyType) && !is_string($policyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyType, true), gettype($policyType)), __LINE__);
        }
        $this->PolicyType = $policyType;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return string|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param string $passengerType
     * @return \StructType\JP_AdditionalPolicy
     */
    public function setPassengerType($passengerType = null)
    {
        // validation for constraint: string
        if (!is_null($passengerType) && !is_string($passengerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passengerType, true), gettype($passengerType)), __LINE__);
        }
        $this->PassengerType = $passengerType;
        return $this;
    }
}
