<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CheckAvailAdvancedOptions StructType
 * @subpackage Structs
 */
abstract class JP_CheckAvailAdvancedOptions extends JP_BaseAdvancedOptions
{
    /**
     * The UseCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UseCurrency;
    /**
     * The ShowBreakdownPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowBreakdownPrice;
    /**
     * Constructor method for JP_CheckAvailAdvancedOptions
     * @uses JP_CheckAvailAdvancedOptions::setUseCurrency()
     * @uses JP_CheckAvailAdvancedOptions::setShowBreakdownPrice()
     * @param string $useCurrency
     * @param bool $showBreakdownPrice
     */
    public function __construct($useCurrency = null, $showBreakdownPrice = null)
    {
        $this
            ->setUseCurrency($useCurrency)
            ->setShowBreakdownPrice($showBreakdownPrice);
    }
    /**
     * Get UseCurrency value
     * @return string|null
     */
    public function getUseCurrency()
    {
        return $this->UseCurrency;
    }
    /**
     * Set UseCurrency value
     * @param string $useCurrency
     * @return \StructType\JP_CheckAvailAdvancedOptions
     */
    public function setUseCurrency($useCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($useCurrency) && !is_string($useCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useCurrency)), __LINE__);
        }
        $this->UseCurrency = $useCurrency;
        return $this;
    }
    /**
     * Get ShowBreakdownPrice value
     * @return bool|null
     */
    public function getShowBreakdownPrice()
    {
        return $this->ShowBreakdownPrice;
    }
    /**
     * Set ShowBreakdownPrice value
     * @param bool $showBreakdownPrice
     * @return \StructType\JP_CheckAvailAdvancedOptions
     */
    public function setShowBreakdownPrice($showBreakdownPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($showBreakdownPrice) && !is_bool($showBreakdownPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($showBreakdownPrice)), __LINE__);
        }
        $this->ShowBreakdownPrice = $showBreakdownPrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CheckAvailAdvancedOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
