<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PackageListRequest StructType
 * @subpackage Structs
 */
class JP_PackageListRequest extends AbstractStructBase
{
    /**
     * The Suppliers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString5
     */
    public $Suppliers;
    /**
     * The OriginZone
     * @var int
     */
    public $OriginZone;
    /**
     * The DestinationZone
     * @var int
     */
    public $DestinationZone;
    /**
     * The Masters
     * @var bool
     */
    public $Masters;
    /**
     * Constructor method for JP_PackageListRequest
     * @uses JP_PackageListRequest::setSuppliers()
     * @uses JP_PackageListRequest::setOriginZone()
     * @uses JP_PackageListRequest::setDestinationZone()
     * @uses JP_PackageListRequest::setMasters()
     * @param \ArrayType\ArrayOfString5 $suppliers
     * @param int $originZone
     * @param int $destinationZone
     * @param bool $masters
     */
    public function __construct(\ArrayType\ArrayOfString5 $suppliers = null, $originZone = null, $destinationZone = null, $masters = null)
    {
        $this
            ->setSuppliers($suppliers)
            ->setOriginZone($originZone)
            ->setDestinationZone($destinationZone)
            ->setMasters($masters);
    }
    /**
     * Get Suppliers value
     * @return \ArrayType\ArrayOfString5|null
     */
    public function getSuppliers()
    {
        return $this->Suppliers;
    }
    /**
     * Set Suppliers value
     * @param \ArrayType\ArrayOfString5 $suppliers
     * @return \StructType\JP_PackageListRequest
     */
    public function setSuppliers(\ArrayType\ArrayOfString5 $suppliers = null)
    {
        $this->Suppliers = $suppliers;
        return $this;
    }
    /**
     * Get OriginZone value
     * @return int|null
     */
    public function getOriginZone()
    {
        return $this->OriginZone;
    }
    /**
     * Set OriginZone value
     * @param int $originZone
     * @return \StructType\JP_PackageListRequest
     */
    public function setOriginZone($originZone = null)
    {
        // validation for constraint: int
        if (!is_null($originZone) && !is_numeric($originZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($originZone)), __LINE__);
        }
        $this->OriginZone = $originZone;
        return $this;
    }
    /**
     * Get DestinationZone value
     * @return int|null
     */
    public function getDestinationZone()
    {
        return $this->DestinationZone;
    }
    /**
     * Set DestinationZone value
     * @param int $destinationZone
     * @return \StructType\JP_PackageListRequest
     */
    public function setDestinationZone($destinationZone = null)
    {
        // validation for constraint: int
        if (!is_null($destinationZone) && !is_numeric($destinationZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($destinationZone)), __LINE__);
        }
        $this->DestinationZone = $destinationZone;
        return $this;
    }
    /**
     * Get Masters value
     * @return bool|null
     */
    public function getMasters()
    {
        return $this->Masters;
    }
    /**
     * Set Masters value
     * @param bool $masters
     * @return \StructType\JP_PackageListRequest
     */
    public function setMasters($masters = null)
    {
        // validation for constraint: boolean
        if (!is_null($masters) && !is_bool($masters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($masters)), __LINE__);
        }
        $this->Masters = $masters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_PackageListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
