<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_PackageHotel ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_PackageHotel extends AbstractStructArrayBase
{
    /**
     * The Hotel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_PackageHotel[]
     */
    public $Hotel;
    /**
     * Constructor method for ArrayOfJP_PackageHotel
     * @uses ArrayOfJP_PackageHotel::setHotel()
     * @param \StructType\JP_PackageHotel[] $hotel
     */
    public function __construct(array $hotel = array())
    {
        $this
            ->setHotel($hotel);
    }
    /**
     * Get Hotel value
     * @return \StructType\JP_PackageHotel[]|null
     */
    public function getHotel()
    {
        return $this->Hotel;
    }
    /**
     * Set Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageHotel[] $hotel
     * @return \ArrayType\ArrayOfJP_PackageHotel
     */
    public function setHotel(array $hotel = array())
    {
        foreach ($hotel as $arrayOfJP_PackageHotelHotelItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_PackageHotelHotelItem instanceof \StructType\JP_PackageHotel) {
                throw new \InvalidArgumentException(sprintf('The Hotel property can only contain items of \StructType\JP_PackageHotel, "%s" given', is_object($arrayOfJP_PackageHotelHotelItem) ? get_class($arrayOfJP_PackageHotelHotelItem) : gettype($arrayOfJP_PackageHotelHotelItem)), __LINE__);
            }
        }
        $this->Hotel = $hotel;
        return $this;
    }
    /**
     * Add item to Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageHotel $item
     * @return \ArrayType\ArrayOfJP_PackageHotel
     */
    public function addToHotel(\StructType\JP_PackageHotel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_PackageHotel) {
            throw new \InvalidArgumentException(sprintf('The Hotel property can only contain items of \StructType\JP_PackageHotel, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Hotel[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_PackageHotel|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_PackageHotel|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_PackageHotel|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_PackageHotel|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_PackageHotel|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Hotel
     */
    public function getAttributeName()
    {
        return 'Hotel';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_PackageHotel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
