<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelAdditionalElement StructType
 * @subpackage Structs
 */
class JP_HotelAdditionalElement extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The FreeNights
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_FreeNights
     */
    public $FreeNights;
    /**
     * The Prices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The SupplementRelPaxesDist
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_SupplementRelPaxDist
     */
    public $SupplementRelPaxesDist;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The JPCode
     * @var string
     */
    public $JPCode;
    /**
     * The Class
     * @var string
     */
    public $Class;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Category
     * @var string
     */
    public $Category;
    /**
     * The SpecialType
     * @var string
     */
    public $SpecialType;
    /**
     * The DirectPayment
     * @var bool
     */
    public $DirectPayment;
    /**
     * The NonRefundable
     * @var bool
     */
    public $NonRefundable;
    /**
     * The Optional
     * @var bool
     */
    public $Optional;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The Begin
     * @var string
     */
    public $Begin;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The ServiceDuration
     * @var int
     */
    public $ServiceDuration;
    /**
     * The RoomCategory
     * @var string
     */
    public $RoomCategory;
    /**
     * The PaymentDate
     * @var string
     */
    public $PaymentDate;
    /**
     * The CostValue
     * @var float
     */
    public $CostValue;
    /**
     * The Percentatge
     * @var float
     */
    public $Percentatge;
    /**
     * Constructor method for JP_HotelAdditionalElement
     * @uses JP_HotelAdditionalElement::setName()
     * @uses JP_HotelAdditionalElement::setDescription()
     * @uses JP_HotelAdditionalElement::setFreeNights()
     * @uses JP_HotelAdditionalElement::setPrices()
     * @uses JP_HotelAdditionalElement::setSupplementRelPaxesDist()
     * @uses JP_HotelAdditionalElement::setCode()
     * @uses JP_HotelAdditionalElement::setJPCode()
     * @uses JP_HotelAdditionalElement::setClass()
     * @uses JP_HotelAdditionalElement::setType()
     * @uses JP_HotelAdditionalElement::setCategory()
     * @uses JP_HotelAdditionalElement::setSpecialType()
     * @uses JP_HotelAdditionalElement::setDirectPayment()
     * @uses JP_HotelAdditionalElement::setNonRefundable()
     * @uses JP_HotelAdditionalElement::setOptional()
     * @uses JP_HotelAdditionalElement::setQuantity()
     * @uses JP_HotelAdditionalElement::setBegin()
     * @uses JP_HotelAdditionalElement::setEnd()
     * @uses JP_HotelAdditionalElement::setAmount()
     * @uses JP_HotelAdditionalElement::setCurrency()
     * @uses JP_HotelAdditionalElement::setRatePlanCode()
     * @uses JP_HotelAdditionalElement::setServiceDuration()
     * @uses JP_HotelAdditionalElement::setRoomCategory()
     * @uses JP_HotelAdditionalElement::setPaymentDate()
     * @uses JP_HotelAdditionalElement::setCostValue()
     * @uses JP_HotelAdditionalElement::setPercentatge()
     * @param string $name
     * @param string $description
     * @param \StructType\JP_FreeNights $freeNights
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param \ArrayType\ArrayOfJP_SupplementRelPaxDist $supplementRelPaxesDist
     * @param string $code
     * @param string $jPCode
     * @param string $class
     * @param string $type
     * @param string $category
     * @param string $specialType
     * @param bool $directPayment
     * @param bool $nonRefundable
     * @param bool $optional
     * @param int $quantity
     * @param string $begin
     * @param string $end
     * @param float $amount
     * @param string $currency
     * @param string $ratePlanCode
     * @param int $serviceDuration
     * @param string $roomCategory
     * @param string $paymentDate
     * @param float $costValue
     * @param float $percentatge
     */
    public function __construct($name = null, $description = null, \StructType\JP_FreeNights $freeNights = null, \ArrayType\ArrayOfJP_Price $prices = null, \ArrayType\ArrayOfJP_SupplementRelPaxDist $supplementRelPaxesDist = null, $code = null, $jPCode = null, $class = null, $type = null, $category = null, $specialType = null, $directPayment = null, $nonRefundable = null, $optional = null, $quantity = null, $begin = null, $end = null, $amount = null, $currency = null, $ratePlanCode = null, $serviceDuration = null, $roomCategory = null, $paymentDate = null, $costValue = null, $percentatge = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setFreeNights($freeNights)
            ->setPrices($prices)
            ->setSupplementRelPaxesDist($supplementRelPaxesDist)
            ->setCode($code)
            ->setJPCode($jPCode)
            ->setClass($class)
            ->setType($type)
            ->setCategory($category)
            ->setSpecialType($specialType)
            ->setDirectPayment($directPayment)
            ->setNonRefundable($nonRefundable)
            ->setOptional($optional)
            ->setQuantity($quantity)
            ->setBegin($begin)
            ->setEnd($end)
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setRatePlanCode($ratePlanCode)
            ->setServiceDuration($serviceDuration)
            ->setRoomCategory($roomCategory)
            ->setPaymentDate($paymentDate)
            ->setCostValue($costValue)
            ->setPercentatge($percentatge);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get FreeNights value
     * @return \StructType\JP_FreeNights|null
     */
    public function getFreeNights()
    {
        return $this->FreeNights;
    }
    /**
     * Set FreeNights value
     * @param \StructType\JP_FreeNights $freeNights
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setFreeNights(\StructType\JP_FreeNights $freeNights = null)
    {
        $this->FreeNights = $freeNights;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get SupplementRelPaxesDist value
     * @return \ArrayType\ArrayOfJP_SupplementRelPaxDist|null
     */
    public function getSupplementRelPaxesDist()
    {
        return $this->SupplementRelPaxesDist;
    }
    /**
     * Set SupplementRelPaxesDist value
     * @param \ArrayType\ArrayOfJP_SupplementRelPaxDist $supplementRelPaxesDist
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setSupplementRelPaxesDist(\ArrayType\ArrayOfJP_SupplementRelPaxDist $supplementRelPaxesDist = null)
    {
        $this->SupplementRelPaxesDist = $supplementRelPaxesDist;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get JPCode value
     * @return string|null
     */
    public function getJPCode()
    {
        return $this->JPCode;
    }
    /**
     * Set JPCode value
     * @param string $jPCode
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setJPCode($jPCode = null)
    {
        // validation for constraint: string
        if (!is_null($jPCode) && !is_string($jPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jPCode)), __LINE__);
        }
        $this->JPCode = $jPCode;
        return $this;
    }
    /**
     * Get Class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->Class;
    }
    /**
     * Set Class value
     * @param string $class
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setClass($class = null)
    {
        // validation for constraint: string
        if (!is_null($class) && !is_string($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($class)), __LINE__);
        }
        $this->Class = $class;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\JP_SupplementType::valueIsValid()
     * @uses \EnumType\JP_SupplementType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_SupplementType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\JP_SupplementType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get SpecialType value
     * @return string|null
     */
    public function getSpecialType()
    {
        return $this->SpecialType;
    }
    /**
     * Set SpecialType value
     * @param string $specialType
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setSpecialType($specialType = null)
    {
        // validation for constraint: string
        if (!is_null($specialType) && !is_string($specialType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($specialType)), __LINE__);
        }
        $this->SpecialType = $specialType;
        return $this;
    }
    /**
     * Get DirectPayment value
     * @return bool|null
     */
    public function getDirectPayment()
    {
        return $this->DirectPayment;
    }
    /**
     * Set DirectPayment value
     * @param bool $directPayment
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setDirectPayment($directPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($directPayment) && !is_bool($directPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($directPayment)), __LINE__);
        }
        $this->DirectPayment = $directPayment;
        return $this;
    }
    /**
     * Get NonRefundable value
     * @return bool|null
     */
    public function getNonRefundable()
    {
        return $this->NonRefundable;
    }
    /**
     * Set NonRefundable value
     * @param bool $nonRefundable
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setNonRefundable($nonRefundable = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonRefundable) && !is_bool($nonRefundable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nonRefundable)), __LINE__);
        }
        $this->NonRefundable = $nonRefundable;
        return $this;
    }
    /**
     * Get Optional value
     * @return bool|null
     */
    public function getOptional()
    {
        return $this->Optional;
    }
    /**
     * Set Optional value
     * @param bool $optional
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setOptional($optional = null)
    {
        // validation for constraint: boolean
        if (!is_null($optional) && !is_bool($optional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($optional)), __LINE__);
        }
        $this->Optional = $optional;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Begin value
     * @return string|null
     */
    public function getBegin()
    {
        return $this->Begin;
    }
    /**
     * Set Begin value
     * @param string $begin
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setBegin($begin = null)
    {
        // validation for constraint: string
        if (!is_null($begin) && !is_string($begin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($begin)), __LINE__);
        }
        $this->Begin = $begin;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get ServiceDuration value
     * @return int|null
     */
    public function getServiceDuration()
    {
        return $this->ServiceDuration;
    }
    /**
     * Set ServiceDuration value
     * @param int $serviceDuration
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setServiceDuration($serviceDuration = null)
    {
        // validation for constraint: int
        if (!is_null($serviceDuration) && !is_numeric($serviceDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceDuration)), __LINE__);
        }
        $this->ServiceDuration = $serviceDuration;
        return $this;
    }
    /**
     * Get RoomCategory value
     * @return string|null
     */
    public function getRoomCategory()
    {
        return $this->RoomCategory;
    }
    /**
     * Set RoomCategory value
     * @param string $roomCategory
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setRoomCategory($roomCategory = null)
    {
        // validation for constraint: string
        if (!is_null($roomCategory) && !is_string($roomCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roomCategory)), __LINE__);
        }
        $this->RoomCategory = $roomCategory;
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string|null
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentDate)), __LINE__);
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get CostValue value
     * @return float|null
     */
    public function getCostValue()
    {
        return $this->CostValue;
    }
    /**
     * Set CostValue value
     * @param float $costValue
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setCostValue($costValue = null)
    {
        $this->CostValue = $costValue;
        return $this;
    }
    /**
     * Get Percentatge value
     * @return float|null
     */
    public function getPercentatge()
    {
        return $this->Percentatge;
    }
    /**
     * Set Percentatge value
     * @param float $percentatge
     * @return \StructType\JP_HotelAdditionalElement
     */
    public function setPercentatge($percentatge = null)
    {
        $this->Percentatge = $percentatge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelAdditionalElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
