<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_PackageInfoAFIPAmount ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_PackageInfoAFIPAmount extends AbstractStructArrayBase
{
    /**
     * The AFIPAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_PackageInfoAFIPAmount[]
     */
    public $AFIPAmount;
    /**
     * Constructor method for ArrayOfJP_PackageInfoAFIPAmount
     * @uses ArrayOfJP_PackageInfoAFIPAmount::setAFIPAmount()
     * @param \StructType\JP_PackageInfoAFIPAmount[] $aFIPAmount
     */
    public function __construct(array $aFIPAmount = array())
    {
        $this
            ->setAFIPAmount($aFIPAmount);
    }
    /**
     * Get AFIPAmount value
     * @return \StructType\JP_PackageInfoAFIPAmount[]|null
     */
    public function getAFIPAmount()
    {
        return $this->AFIPAmount;
    }
    /**
     * Set AFIPAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageInfoAFIPAmount[] $aFIPAmount
     * @return \ArrayType\ArrayOfJP_PackageInfoAFIPAmount
     */
    public function setAFIPAmount(array $aFIPAmount = array())
    {
        foreach ($aFIPAmount as $arrayOfJP_PackageInfoAFIPAmountAFIPAmountItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_PackageInfoAFIPAmountAFIPAmountItem instanceof \StructType\JP_PackageInfoAFIPAmount) {
                throw new \InvalidArgumentException(sprintf('The AFIPAmount property can only contain items of \StructType\JP_PackageInfoAFIPAmount, "%s" given', is_object($arrayOfJP_PackageInfoAFIPAmountAFIPAmountItem) ? get_class($arrayOfJP_PackageInfoAFIPAmountAFIPAmountItem) : gettype($arrayOfJP_PackageInfoAFIPAmountAFIPAmountItem)), __LINE__);
            }
        }
        $this->AFIPAmount = $aFIPAmount;
        return $this;
    }
    /**
     * Add item to AFIPAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageInfoAFIPAmount $item
     * @return \ArrayType\ArrayOfJP_PackageInfoAFIPAmount
     */
    public function addToAFIPAmount(\StructType\JP_PackageInfoAFIPAmount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_PackageInfoAFIPAmount) {
            throw new \InvalidArgumentException(sprintf('The AFIPAmount property can only contain items of \StructType\JP_PackageInfoAFIPAmount, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AFIPAmount[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_PackageInfoAFIPAmount|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_PackageInfoAFIPAmount|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_PackageInfoAFIPAmount|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_PackageInfoAFIPAmount|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_PackageInfoAFIPAmount|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AFIPAmount
     */
    public function getAttributeName()
    {
        return 'AFIPAmount';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_PackageInfoAFIPAmount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
