<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Agent StructType
 * @subpackage Structs
 */
class JP_Agent extends AbstractStructBase
{
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Email
     * @var string
     */
    public $Email;
    /**
     * The idCliRef
     * @var int
     */
    public $idCliRef;
    /**
     * Constructor method for JP_Agent
     * @uses JP_Agent::setName()
     * @uses JP_Agent::setEmail()
     * @uses JP_Agent::setIdCliRef()
     * @param string $name
     * @param string $email
     * @param int $idCliRef
     */
    public function __construct($name = null, $email = null, $idCliRef = null)
    {
        $this
            ->setName($name)
            ->setEmail($email)
            ->setIdCliRef($idCliRef);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_Agent
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\JP_Agent
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get idCliRef value
     * @return int|null
     */
    public function getIdCliRef()
    {
        return $this->idCliRef;
    }
    /**
     * Set idCliRef value
     * @param int $idCliRef
     * @return \StructType\JP_Agent
     */
    public function setIdCliRef($idCliRef = null)
    {
        // validation for constraint: int
        if (!is_null($idCliRef) && !(is_int($idCliRef) || ctype_digit($idCliRef))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCliRef, true), gettype($idCliRef)), __LINE__);
        }
        $this->idCliRef = $idCliRef;
        return $this;
    }
}
