<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Document StructType
 * @subpackage Structs
 */
class JP_Document extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The ExpeditionDate
     * @var string
     */
    public $ExpeditionDate;
    /**
     * The City
     * @var string
     */
    public $City;
    /**
     * The Mrz
     * @var string
     */
    public $Mrz;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The ExpirationDate
     * @var string
     */
    public $ExpirationDate;
    /**
     * The Country
     * @var string
     */
    public $Country;
    /**
     * Constructor method for JP_Document
     * @uses JP_Document::set_()
     * @uses JP_Document::setExpeditionDate()
     * @uses JP_Document::setCity()
     * @uses JP_Document::setMrz()
     * @uses JP_Document::setType()
     * @uses JP_Document::setExpirationDate()
     * @uses JP_Document::setCountry()
     * @param string $_
     * @param string $expeditionDate
     * @param string $city
     * @param string $mrz
     * @param string $type
     * @param string $expirationDate
     * @param string $country
     */
    public function __construct($_ = null, $expeditionDate = null, $city = null, $mrz = null, $type = null, $expirationDate = null, $country = null)
    {
        $this
            ->set_($_)
            ->setExpeditionDate($expeditionDate)
            ->setCity($city)
            ->setMrz($mrz)
            ->setType($type)
            ->setExpirationDate($expirationDate)
            ->setCountry($country);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\JP_Document
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get ExpeditionDate value
     * @return string|null
     */
    public function getExpeditionDate()
    {
        return $this->ExpeditionDate;
    }
    /**
     * Set ExpeditionDate value
     * @param string $expeditionDate
     * @return \StructType\JP_Document
     */
    public function setExpeditionDate($expeditionDate = null)
    {
        // validation for constraint: string
        if (!is_null($expeditionDate) && !is_string($expeditionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expeditionDate, true), gettype($expeditionDate)), __LINE__);
        }
        $this->ExpeditionDate = $expeditionDate;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\JP_Document
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Mrz value
     * @return string|null
     */
    public function getMrz()
    {
        return $this->Mrz;
    }
    /**
     * Set Mrz value
     * @param string $mrz
     * @return \StructType\JP_Document
     */
    public function setMrz($mrz = null)
    {
        // validation for constraint: string
        if (!is_null($mrz) && !is_string($mrz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mrz, true), gettype($mrz)), __LINE__);
        }
        $this->Mrz = $mrz;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\JP_DocumentType::valueIsValid()
     * @uses \EnumType\JP_DocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\JP_Document
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_DocumentType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_DocumentType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\JP_DocumentType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\JP_Document
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\JP_Document
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
}
