<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransferContentOption StructType
 * @subpackage Structs
 */
class JP_TransferContentOption extends JP_TransferOption
{
    /**
     * The Descriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Description
     */
    public $Descriptions;
    /**
     * The MeetingPointList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_MeetingPointsZone
     */
    public $MeetingPointList;
    /**
     * The MinimumPax
     * @var int
     */
    public $MinimumPax;
    /**
     * The MaximumPax
     * @var int
     */
    public $MaximumPax;
    /**
     * Constructor method for JP_TransferContentOption
     * @uses JP_TransferContentOption::setDescriptions()
     * @uses JP_TransferContentOption::setMeetingPointList()
     * @uses JP_TransferContentOption::setMinimumPax()
     * @uses JP_TransferContentOption::setMaximumPax()
     * @param \ArrayType\ArrayOfJP_Description $descriptions
     * @param \StructType\JP_MeetingPointsZone $meetingPointList
     * @param int $minimumPax
     * @param int $maximumPax
     */
    public function __construct(\ArrayType\ArrayOfJP_Description $descriptions = null, \StructType\JP_MeetingPointsZone $meetingPointList = null, $minimumPax = null, $maximumPax = null)
    {
        $this
            ->setDescriptions($descriptions)
            ->setMeetingPointList($meetingPointList)
            ->setMinimumPax($minimumPax)
            ->setMaximumPax($maximumPax);
    }
    /**
     * Get Descriptions value
     * @return \ArrayType\ArrayOfJP_Description|null
     */
    public function getDescriptions()
    {
        return $this->Descriptions;
    }
    /**
     * Set Descriptions value
     * @param \ArrayType\ArrayOfJP_Description $descriptions
     * @return \StructType\JP_TransferContentOption
     */
    public function setDescriptions(\ArrayType\ArrayOfJP_Description $descriptions = null)
    {
        $this->Descriptions = $descriptions;
        return $this;
    }
    /**
     * Get MeetingPointList value
     * @return \StructType\JP_MeetingPointsZone|null
     */
    public function getMeetingPointList()
    {
        return $this->MeetingPointList;
    }
    /**
     * Set MeetingPointList value
     * @param \StructType\JP_MeetingPointsZone $meetingPointList
     * @return \StructType\JP_TransferContentOption
     */
    public function setMeetingPointList(\StructType\JP_MeetingPointsZone $meetingPointList = null)
    {
        $this->MeetingPointList = $meetingPointList;
        return $this;
    }
    /**
     * Get MinimumPax value
     * @return int|null
     */
    public function getMinimumPax()
    {
        return $this->MinimumPax;
    }
    /**
     * Set MinimumPax value
     * @param int $minimumPax
     * @return \StructType\JP_TransferContentOption
     */
    public function setMinimumPax($minimumPax = null)
    {
        // validation for constraint: int
        if (!is_null($minimumPax) && !(is_int($minimumPax) || ctype_digit($minimumPax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumPax, true), gettype($minimumPax)), __LINE__);
        }
        $this->MinimumPax = $minimumPax;
        return $this;
    }
    /**
     * Get MaximumPax value
     * @return int|null
     */
    public function getMaximumPax()
    {
        return $this->MaximumPax;
    }
    /**
     * Set MaximumPax value
     * @param int $maximumPax
     * @return \StructType\JP_TransferContentOption
     */
    public function setMaximumPax($maximumPax = null)
    {
        // validation for constraint: int
        if (!is_null($maximumPax) && !(is_int($maximumPax) || ctype_digit($maximumPax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumPax, true), gettype($maximumPax)), __LINE__);
        }
        $this->MaximumPax = $maximumPax;
        return $this;
    }
}
