<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelOption StructType
 * @subpackage Structs
 */
class JP_HotelOption extends AbstractStructBase
{
    /**
     * The PackageContract
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $PackageContract;
    /**
     * The Supplier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Supplier
     */
    public $Supplier;
    /**
     * The Board
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Board
     */
    public $Board;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The CancellationPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicy;
    /**
     * The CancellationPolicyCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicyCost;
    /**
     * The HotelRooms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_HotelRoom
     */
    public $HotelRooms;
    /**
     * The AdditionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelAdditionalElements
     */
    public $AdditionalElements;
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductType;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The PaymentDestination
     * @var bool
     */
    public $PaymentDestination;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The NonRefundable
     * @var bool
     */
    public $NonRefundable;
    /**
     * The DynamicInventory
     * @var bool
     */
    public $DynamicInventory;
    /**
     * The ExtranetContract
     * @var bool
     */
    public $ExtranetContract;
    /**
     * Constructor method for JP_HotelOption
     * @uses JP_HotelOption::setPackageContract()
     * @uses JP_HotelOption::setSupplier()
     * @uses JP_HotelOption::setBoard()
     * @uses JP_HotelOption::setPrices()
     * @uses JP_HotelOption::setCancellationPolicy()
     * @uses JP_HotelOption::setCancellationPolicyCost()
     * @uses JP_HotelOption::setHotelRooms()
     * @uses JP_HotelOption::setAdditionalElements()
     * @uses JP_HotelOption::setProductType()
     * @uses JP_HotelOption::setRatePlanCode()
     * @uses JP_HotelOption::setPaymentDestination()
     * @uses JP_HotelOption::setStatus()
     * @uses JP_HotelOption::setNonRefundable()
     * @uses JP_HotelOption::setDynamicInventory()
     * @uses JP_HotelOption::setExtranetContract()
     * @param bool $packageContract
     * @param \StructType\JP_Supplier $supplier
     * @param \StructType\JP_Board $board
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @param \ArrayType\ArrayOfJP_HotelRoom $hotelRooms
     * @param \StructType\JP_HotelAdditionalElements $additionalElements
     * @param string $productType
     * @param string $ratePlanCode
     * @param bool $paymentDestination
     * @param string $status
     * @param bool $nonRefundable
     * @param bool $dynamicInventory
     * @param bool $extranetContract
     */
    public function __construct($packageContract = null, \StructType\JP_Supplier $supplier = null, \StructType\JP_Board $board = null, \ArrayType\ArrayOfJP_Price $prices = null, \StructType\JP_CancellationPolicyRules $cancellationPolicy = null, \StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null, \ArrayType\ArrayOfJP_HotelRoom $hotelRooms = null, \StructType\JP_HotelAdditionalElements $additionalElements = null, $productType = null, $ratePlanCode = null, $paymentDestination = null, $status = null, $nonRefundable = null, $dynamicInventory = null, $extranetContract = null)
    {
        $this
            ->setPackageContract($packageContract)
            ->setSupplier($supplier)
            ->setBoard($board)
            ->setPrices($prices)
            ->setCancellationPolicy($cancellationPolicy)
            ->setCancellationPolicyCost($cancellationPolicyCost)
            ->setHotelRooms($hotelRooms)
            ->setAdditionalElements($additionalElements)
            ->setProductType($productType)
            ->setRatePlanCode($ratePlanCode)
            ->setPaymentDestination($paymentDestination)
            ->setStatus($status)
            ->setNonRefundable($nonRefundable)
            ->setDynamicInventory($dynamicInventory)
            ->setExtranetContract($extranetContract);
    }
    /**
     * Get PackageContract value
     * @return bool
     */
    public function getPackageContract()
    {
        return $this->PackageContract;
    }
    /**
     * Set PackageContract value
     * @param bool $packageContract
     * @return \StructType\JP_HotelOption
     */
    public function setPackageContract($packageContract = null)
    {
        // validation for constraint: boolean
        if (!is_null($packageContract) && !is_bool($packageContract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($packageContract, true), gettype($packageContract)), __LINE__);
        }
        $this->PackageContract = $packageContract;
        return $this;
    }
    /**
     * Get Supplier value
     * @return \StructType\JP_Supplier|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param \StructType\JP_Supplier $supplier
     * @return \StructType\JP_HotelOption
     */
    public function setSupplier(\StructType\JP_Supplier $supplier = null)
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get Board value
     * @return \StructType\JP_Board|null
     */
    public function getBoard()
    {
        return $this->Board;
    }
    /**
     * Set Board value
     * @param \StructType\JP_Board $board
     * @return \StructType\JP_HotelOption
     */
    public function setBoard(\StructType\JP_Board $board = null)
    {
        $this->Board = $board;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_HotelOption
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get CancellationPolicy value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicy()
    {
        return $this->CancellationPolicy;
    }
    /**
     * Set CancellationPolicy value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @return \StructType\JP_HotelOption
     */
    public function setCancellationPolicy(\StructType\JP_CancellationPolicyRules $cancellationPolicy = null)
    {
        $this->CancellationPolicy = $cancellationPolicy;
        return $this;
    }
    /**
     * Get CancellationPolicyCost value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicyCost()
    {
        return $this->CancellationPolicyCost;
    }
    /**
     * Set CancellationPolicyCost value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @return \StructType\JP_HotelOption
     */
    public function setCancellationPolicyCost(\StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null)
    {
        $this->CancellationPolicyCost = $cancellationPolicyCost;
        return $this;
    }
    /**
     * Get HotelRooms value
     * @return \ArrayType\ArrayOfJP_HotelRoom|null
     */
    public function getHotelRooms()
    {
        return $this->HotelRooms;
    }
    /**
     * Set HotelRooms value
     * @param \ArrayType\ArrayOfJP_HotelRoom $hotelRooms
     * @return \StructType\JP_HotelOption
     */
    public function setHotelRooms(\ArrayType\ArrayOfJP_HotelRoom $hotelRooms = null)
    {
        $this->HotelRooms = $hotelRooms;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_HotelAdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_HotelAdditionalElements $additionalElements
     * @return \StructType\JP_HotelOption
     */
    public function setAdditionalElements(\StructType\JP_HotelAdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @param string $productType
     * @return \StructType\JP_HotelOption
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_HotelOption
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get PaymentDestination value
     * @return bool|null
     */
    public function getPaymentDestination()
    {
        return $this->PaymentDestination;
    }
    /**
     * Set PaymentDestination value
     * @param bool $paymentDestination
     * @return \StructType\JP_HotelOption
     */
    public function setPaymentDestination($paymentDestination = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentDestination) && !is_bool($paymentDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paymentDestination, true), gettype($paymentDestination)), __LINE__);
        }
        $this->PaymentDestination = $paymentDestination;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_HotelOption
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get NonRefundable value
     * @return bool|null
     */
    public function getNonRefundable()
    {
        return $this->NonRefundable;
    }
    /**
     * Set NonRefundable value
     * @param bool $nonRefundable
     * @return \StructType\JP_HotelOption
     */
    public function setNonRefundable($nonRefundable = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonRefundable) && !is_bool($nonRefundable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonRefundable, true), gettype($nonRefundable)), __LINE__);
        }
        $this->NonRefundable = $nonRefundable;
        return $this;
    }
    /**
     * Get DynamicInventory value
     * @return bool|null
     */
    public function getDynamicInventory()
    {
        return $this->DynamicInventory;
    }
    /**
     * Set DynamicInventory value
     * @param bool $dynamicInventory
     * @return \StructType\JP_HotelOption
     */
    public function setDynamicInventory($dynamicInventory = null)
    {
        // validation for constraint: boolean
        if (!is_null($dynamicInventory) && !is_bool($dynamicInventory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dynamicInventory, true), gettype($dynamicInventory)), __LINE__);
        }
        $this->DynamicInventory = $dynamicInventory;
        return $this;
    }
    /**
     * Get ExtranetContract value
     * @return bool|null
     */
    public function getExtranetContract()
    {
        return $this->ExtranetContract;
    }
    /**
     * Set ExtranetContract value
     * @param bool $extranetContract
     * @return \StructType\JP_HotelOption
     */
    public function setExtranetContract($extranetContract = null)
    {
        // validation for constraint: boolean
        if (!is_null($extranetContract) && !is_bool($extranetContract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($extranetContract, true), gettype($extranetContract)), __LINE__);
        }
        $this->ExtranetContract = $extranetContract;
        return $this;
    }
}
