<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_BaseSupleOfferRest StructType
 * @subpackage Structs
 */
abstract class JPSOAP_BaseSupleOfferRest extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Code;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Active;
    /**
     * The OnRequest
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $OnRequest;
    /**
     * The SpecialTax
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $SpecialTax;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Ages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_Ages
     */
    public $Ages;
    /**
     * The RoomTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJPSOAP_IntCodeAttr2
     */
    public $RoomTypes;
    /**
     * The Boards
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJPSOAP_IntCodeAttr3
     */
    public $Boards;
    /**
     * The CountryOfResidence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JPSOAP_CountryOfResidence
     */
    public $CountryOfResidence;
    /**
     * The CategoryCode
     * @var int
     */
    public $CategoryCode;
    /**
     * The SpecialTypeCode
     * @var int
     */
    public $SpecialTypeCode;
    /**
     * Constructor method for JPSOAP_BaseSupleOfferRest
     * @uses JPSOAP_BaseSupleOfferRest::setCode()
     * @uses JPSOAP_BaseSupleOfferRest::setActive()
     * @uses JPSOAP_BaseSupleOfferRest::setOnRequest()
     * @uses JPSOAP_BaseSupleOfferRest::setSpecialTax()
     * @uses JPSOAP_BaseSupleOfferRest::setName()
     * @uses JPSOAP_BaseSupleOfferRest::setAges()
     * @uses JPSOAP_BaseSupleOfferRest::setRoomTypes()
     * @uses JPSOAP_BaseSupleOfferRest::setBoards()
     * @uses JPSOAP_BaseSupleOfferRest::setCountryOfResidence()
     * @uses JPSOAP_BaseSupleOfferRest::setCategoryCode()
     * @uses JPSOAP_BaseSupleOfferRest::setSpecialTypeCode()
     * @param int $code
     * @param bool $active
     * @param bool $onRequest
     * @param bool $specialTax
     * @param string $name
     * @param \StructType\JPSOAP_Ages $ages
     * @param \ArrayType\ArrayOfJPSOAP_IntCodeAttr2 $roomTypes
     * @param \ArrayType\ArrayOfJPSOAP_IntCodeAttr3 $boards
     * @param \StructType\JPSOAP_CountryOfResidence $countryOfResidence
     * @param int $categoryCode
     * @param int $specialTypeCode
     */
    public function __construct($code = null, $active = null, $onRequest = null, $specialTax = null, $name = null, \StructType\JPSOAP_Ages $ages = null, \ArrayType\ArrayOfJPSOAP_IntCodeAttr2 $roomTypes = null, \ArrayType\ArrayOfJPSOAP_IntCodeAttr3 $boards = null, \StructType\JPSOAP_CountryOfResidence $countryOfResidence = null, $categoryCode = null, $specialTypeCode = null)
    {
        $this
            ->setCode($code)
            ->setActive($active)
            ->setOnRequest($onRequest)
            ->setSpecialTax($specialTax)
            ->setName($name)
            ->setAges($ages)
            ->setRoomTypes($roomTypes)
            ->setBoards($boards)
            ->setCountryOfResidence($countryOfResidence)
            ->setCategoryCode($categoryCode)
            ->setSpecialTypeCode($specialTypeCode);
    }
    /**
     * Get Code value
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\JPSOAP_BaseSupleOfferRest
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\JPSOAP_BaseSupleOfferRest
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get OnRequest value
     * @return bool
     */
    public function getOnRequest()
    {
        return $this->OnRequest;
    }
    /**
     * Set OnRequest value
     * @param bool $onRequest
     * @return \StructType\JPSOAP_BaseSupleOfferRest
     */
    public function setOnRequest($onRequest = null)
    {
        // validation for constraint: boolean
        if (!is_null($onRequest) && !is_bool($onRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onRequest, true), gettype($onRequest)), __LINE__);
        }
        $this->OnRequest = $onRequest;
        return $this;
    }
    /**
     * Get SpecialTax value
     * @return bool
     */
    public function getSpecialTax()
    {
        return $this->SpecialTax;
    }
    /**
     * Set SpecialTax value
     * @param bool $specialTax
     * @return \StructType\JPSOAP_BaseSupleOfferRest
     */
    public function setSpecialTax($specialTax = null)
    {
        // validation for constraint: boolean
        if (!is_null($specialTax) && !is_bool($specialTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($specialTax, true), gettype($specialTax)), __LINE__);
        }
        $this->SpecialTax = $specialTax;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JPSOAP_BaseSupleOfferRest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Ages value
     * @return \StructType\JPSOAP_Ages|null
     */
    public function getAges()
    {
        return $this->Ages;
    }
    /**
     * Set Ages value
     * @param \StructType\JPSOAP_Ages $ages
     * @return \StructType\JPSOAP_BaseSupleOfferRest
     */
    public function setAges(\StructType\JPSOAP_Ages $ages = null)
    {
        $this->Ages = $ages;
        return $this;
    }
    /**
     * Get RoomTypes value
     * @return \ArrayType\ArrayOfJPSOAP_IntCodeAttr2|null
     */
    public function getRoomTypes()
    {
        return $this->RoomTypes;
    }
    /**
     * Set RoomTypes value
     * @param \ArrayType\ArrayOfJPSOAP_IntCodeAttr2 $roomTypes
     * @return \StructType\JPSOAP_BaseSupleOfferRest
     */
    public function setRoomTypes(\ArrayType\ArrayOfJPSOAP_IntCodeAttr2 $roomTypes = null)
    {
        $this->RoomTypes = $roomTypes;
        return $this;
    }
    /**
     * Get Boards value
     * @return \ArrayType\ArrayOfJPSOAP_IntCodeAttr3|null
     */
    public function getBoards()
    {
        return $this->Boards;
    }
    /**
     * Set Boards value
     * @param \ArrayType\ArrayOfJPSOAP_IntCodeAttr3 $boards
     * @return \StructType\JPSOAP_BaseSupleOfferRest
     */
    public function setBoards(\ArrayType\ArrayOfJPSOAP_IntCodeAttr3 $boards = null)
    {
        $this->Boards = $boards;
        return $this;
    }
    /**
     * Get CountryOfResidence value
     * @return \StructType\JPSOAP_CountryOfResidence|null
     */
    public function getCountryOfResidence()
    {
        return $this->CountryOfResidence;
    }
    /**
     * Set CountryOfResidence value
     * @param \StructType\JPSOAP_CountryOfResidence $countryOfResidence
     * @return \StructType\JPSOAP_BaseSupleOfferRest
     */
    public function setCountryOfResidence(\StructType\JPSOAP_CountryOfResidence $countryOfResidence = null)
    {
        $this->CountryOfResidence = $countryOfResidence;
        return $this;
    }
    /**
     * Get CategoryCode value
     * @return int|null
     */
    public function getCategoryCode()
    {
        return $this->CategoryCode;
    }
    /**
     * Set CategoryCode value
     * @param int $categoryCode
     * @return \StructType\JPSOAP_BaseSupleOfferRest
     */
    public function setCategoryCode($categoryCode = null)
    {
        // validation for constraint: int
        if (!is_null($categoryCode) && !(is_int($categoryCode) || ctype_digit($categoryCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($categoryCode, true), gettype($categoryCode)), __LINE__);
        }
        $this->CategoryCode = $categoryCode;
        return $this;
    }
    /**
     * Get SpecialTypeCode value
     * @return int|null
     */
    public function getSpecialTypeCode()
    {
        return $this->SpecialTypeCode;
    }
    /**
     * Set SpecialTypeCode value
     * @param int $specialTypeCode
     * @return \StructType\JPSOAP_BaseSupleOfferRest
     */
    public function setSpecialTypeCode($specialTypeCode = null)
    {
        // validation for constraint: int
        if (!is_null($specialTypeCode) && !(is_int($specialTypeCode) || ctype_digit($specialTypeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($specialTypeCode, true), gettype($specialTypeCode)), __LINE__);
        }
        $this->SpecialTypeCode = $specialTypeCode;
        return $this;
    }
}
