<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TotalFixAmounts StructType
 * @subpackage Structs
 */
class JP_TotalFixAmounts extends AbstractStructBase
{
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Service
     */
    public $Service;
    /**
     * The ServiceTaxes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServiceTaxes
     */
    public $ServiceTaxes;
    /**
     * The Loyalty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Loyalty_Points
     */
    public $Loyalty;
    /**
     * The Commissions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Commissions
     */
    public $Commissions;
    /**
     * The HandlingFees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HandlingFees
     */
    public $HandlingFees;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Discount
     */
    public $Discount;
    /**
     * The Recommended
     * @var float
     */
    public $Recommended;
    /**
     * The Gross
     * @var float
     */
    public $Gross;
    /**
     * The Nett
     * @var float
     */
    public $Nett;
    /**
     * Constructor method for JP_TotalFixAmounts
     * @uses JP_TotalFixAmounts::setService()
     * @uses JP_TotalFixAmounts::setServiceTaxes()
     * @uses JP_TotalFixAmounts::setLoyalty()
     * @uses JP_TotalFixAmounts::setCommissions()
     * @uses JP_TotalFixAmounts::setHandlingFees()
     * @uses JP_TotalFixAmounts::setDiscount()
     * @uses JP_TotalFixAmounts::setRecommended()
     * @uses JP_TotalFixAmounts::setGross()
     * @uses JP_TotalFixAmounts::setNett()
     * @param \StructType\JP_Service $service
     * @param \StructType\JP_ServiceTaxes $serviceTaxes
     * @param \StructType\JP_Loyalty_Points $loyalty
     * @param \StructType\JP_Commissions $commissions
     * @param \StructType\JP_HandlingFees $handlingFees
     * @param \StructType\JP_Discount $discount
     * @param float $recommended
     * @param float $gross
     * @param float $nett
     */
    public function __construct(\StructType\JP_Service $service = null, \StructType\JP_ServiceTaxes $serviceTaxes = null, \StructType\JP_Loyalty_Points $loyalty = null, \StructType\JP_Commissions $commissions = null, \StructType\JP_HandlingFees $handlingFees = null, \StructType\JP_Discount $discount = null, $recommended = null, $gross = null, $nett = null)
    {
        $this
            ->setService($service)
            ->setServiceTaxes($serviceTaxes)
            ->setLoyalty($loyalty)
            ->setCommissions($commissions)
            ->setHandlingFees($handlingFees)
            ->setDiscount($discount)
            ->setRecommended($recommended)
            ->setGross($gross)
            ->setNett($nett);
    }
    /**
     * Get Service value
     * @return \StructType\JP_Service|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \StructType\JP_Service $service
     * @return \StructType\JP_TotalFixAmounts
     */
    public function setService(\StructType\JP_Service $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get ServiceTaxes value
     * @return \StructType\JP_ServiceTaxes|null
     */
    public function getServiceTaxes()
    {
        return $this->ServiceTaxes;
    }
    /**
     * Set ServiceTaxes value
     * @param \StructType\JP_ServiceTaxes $serviceTaxes
     * @return \StructType\JP_TotalFixAmounts
     */
    public function setServiceTaxes(\StructType\JP_ServiceTaxes $serviceTaxes = null)
    {
        $this->ServiceTaxes = $serviceTaxes;
        return $this;
    }
    /**
     * Get Loyalty value
     * @return \StructType\JP_Loyalty_Points|null
     */
    public function getLoyalty()
    {
        return $this->Loyalty;
    }
    /**
     * Set Loyalty value
     * @param \StructType\JP_Loyalty_Points $loyalty
     * @return \StructType\JP_TotalFixAmounts
     */
    public function setLoyalty(\StructType\JP_Loyalty_Points $loyalty = null)
    {
        $this->Loyalty = $loyalty;
        return $this;
    }
    /**
     * Get Commissions value
     * @return \StructType\JP_Commissions|null
     */
    public function getCommissions()
    {
        return $this->Commissions;
    }
    /**
     * Set Commissions value
     * @param \StructType\JP_Commissions $commissions
     * @return \StructType\JP_TotalFixAmounts
     */
    public function setCommissions(\StructType\JP_Commissions $commissions = null)
    {
        $this->Commissions = $commissions;
        return $this;
    }
    /**
     * Get HandlingFees value
     * @return \StructType\JP_HandlingFees|null
     */
    public function getHandlingFees()
    {
        return $this->HandlingFees;
    }
    /**
     * Set HandlingFees value
     * @param \StructType\JP_HandlingFees $handlingFees
     * @return \StructType\JP_TotalFixAmounts
     */
    public function setHandlingFees(\StructType\JP_HandlingFees $handlingFees = null)
    {
        $this->HandlingFees = $handlingFees;
        return $this;
    }
    /**
     * Get Discount value
     * @return \StructType\JP_Discount|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param \StructType\JP_Discount $discount
     * @return \StructType\JP_TotalFixAmounts
     */
    public function setDiscount(\StructType\JP_Discount $discount = null)
    {
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get Recommended value
     * @return float|null
     */
    public function getRecommended()
    {
        return $this->Recommended;
    }
    /**
     * Set Recommended value
     * @param float $recommended
     * @return \StructType\JP_TotalFixAmounts
     */
    public function setRecommended($recommended = null)
    {
        // validation for constraint: float
        if (!is_null($recommended) && !(is_float($recommended) || is_numeric($recommended))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($recommended, true), gettype($recommended)), __LINE__);
        }
        $this->Recommended = $recommended;
        return $this;
    }
    /**
     * Get Gross value
     * @return float|null
     */
    public function getGross()
    {
        return $this->Gross;
    }
    /**
     * Set Gross value
     * @param float $gross
     * @return \StructType\JP_TotalFixAmounts
     */
    public function setGross($gross = null)
    {
        // validation for constraint: float
        if (!is_null($gross) && !(is_float($gross) || is_numeric($gross))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gross, true), gettype($gross)), __LINE__);
        }
        $this->Gross = $gross;
        return $this;
    }
    /**
     * Get Nett value
     * @return float|null
     */
    public function getNett()
    {
        return $this->Nett;
    }
    /**
     * Set Nett value
     * @param float $nett
     * @return \StructType\JP_TotalFixAmounts
     */
    public function setNett($nett = null)
    {
        // validation for constraint: float
        if (!is_null($nett) && !(is_float($nett) || is_numeric($nett))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nett, true), gettype($nett)), __LINE__);
        }
        $this->Nett = $nett;
        return $this;
    }
}
