<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_VisaItem StructType
 * @subpackage Structs
 */
class JP_VisaItem extends JP_BaseItem
{
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The VisaInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_VisaInfo
     */
    public $VisaInfo;
    /**
     * The AdditionalElements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PackageAdditionalElements
     */
    public $AdditionalElements;
    /**
     * The CancellationPolicy
     * Meta information extracted from the WSDL
     * - form: unqualified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicy;
    /**
     * The VisaOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_VisaOption
     */
    public $VisaOptions;
    /**
     * The RelPaxes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_RelPax
     */
    public $RelPaxes;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_VisaItem
     * @uses JP_VisaItem::setStart()
     * @uses JP_VisaItem::setEnd()
     * @uses JP_VisaItem::setVisaInfo()
     * @uses JP_VisaItem::setAdditionalElements()
     * @uses JP_VisaItem::setCancellationPolicy()
     * @uses JP_VisaItem::setVisaOptions()
     * @uses JP_VisaItem::setRelPaxes()
     * @uses JP_VisaItem::setCode()
     * @param string $start
     * @param string $end
     * @param \StructType\JP_VisaInfo $visaInfo
     * @param \StructType\JP_PackageAdditionalElements $additionalElements
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @param \ArrayType\ArrayOfJP_VisaOption $visaOptions
     * @param \ArrayType\ArrayOfJP_RelPax $relPaxes
     * @param string $code
     */
    public function __construct($start = null, $end = null, \StructType\JP_VisaInfo $visaInfo = null, \StructType\JP_PackageAdditionalElements $additionalElements = null, \StructType\JP_CancellationPolicyRules $cancellationPolicy = null, \ArrayType\ArrayOfJP_VisaOption $visaOptions = null, \ArrayType\ArrayOfJP_RelPax $relPaxes = null, $code = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setVisaInfo($visaInfo)
            ->setAdditionalElements($additionalElements)
            ->setCancellationPolicy($cancellationPolicy)
            ->setVisaOptions($visaOptions)
            ->setRelPaxes($relPaxes)
            ->setCode($code);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_VisaItem
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_VisaItem
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get VisaInfo value
     * @return \StructType\JP_VisaInfo|null
     */
    public function getVisaInfo()
    {
        return $this->VisaInfo;
    }
    /**
     * Set VisaInfo value
     * @param \StructType\JP_VisaInfo $visaInfo
     * @return \StructType\JP_VisaItem
     */
    public function setVisaInfo(\StructType\JP_VisaInfo $visaInfo = null)
    {
        $this->VisaInfo = $visaInfo;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_PackageAdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_PackageAdditionalElements $additionalElements
     * @return \StructType\JP_VisaItem
     */
    public function setAdditionalElements(\StructType\JP_PackageAdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get CancellationPolicy value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicy()
    {
        return $this->CancellationPolicy;
    }
    /**
     * Set CancellationPolicy value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @return \StructType\JP_VisaItem
     */
    public function setCancellationPolicy(\StructType\JP_CancellationPolicyRules $cancellationPolicy = null)
    {
        $this->CancellationPolicy = $cancellationPolicy;
        return $this;
    }
    /**
     * Get VisaOptions value
     * @return \ArrayType\ArrayOfJP_VisaOption|null
     */
    public function getVisaOptions()
    {
        return $this->VisaOptions;
    }
    /**
     * Set VisaOptions value
     * @param \ArrayType\ArrayOfJP_VisaOption $visaOptions
     * @return \StructType\JP_VisaItem
     */
    public function setVisaOptions(\ArrayType\ArrayOfJP_VisaOption $visaOptions = null)
    {
        $this->VisaOptions = $visaOptions;
        return $this;
    }
    /**
     * Get RelPaxes value
     * @return \ArrayType\ArrayOfJP_RelPax|null
     */
    public function getRelPaxes()
    {
        return $this->RelPaxes;
    }
    /**
     * Set RelPaxes value
     * @param \ArrayType\ArrayOfJP_RelPax $relPaxes
     * @return \StructType\JP_VisaItem
     */
    public function setRelPaxes(\ArrayType\ArrayOfJP_RelPax $relPaxes = null)
    {
        $this->RelPaxes = $relPaxes;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_VisaItem
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
}
