<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_AccommodationPortfolio StructType
 * @subpackage Structs
 */
class JP_AccommodationPortfolio extends AbstractStructBase
{
    /**
     * The Hotel
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ExtendedHotelInfo[]
     */
    public $Hotel;
    /**
     * The Page
     * @var int
     */
    public $Page;
    /**
     * The RecordsPerPage
     * @var int
     */
    public $RecordsPerPage;
    /**
     * The TotalPages
     * @var int
     */
    public $TotalPages;
    /**
     * The TotalRecords
     * @var int
     */
    public $TotalRecords;
    /**
     * The NextToken
     * @var string
     */
    public $NextToken;
    /**
     * Constructor method for JP_AccommodationPortfolio
     * @uses JP_AccommodationPortfolio::setHotel()
     * @uses JP_AccommodationPortfolio::setPage()
     * @uses JP_AccommodationPortfolio::setRecordsPerPage()
     * @uses JP_AccommodationPortfolio::setTotalPages()
     * @uses JP_AccommodationPortfolio::setTotalRecords()
     * @uses JP_AccommodationPortfolio::setNextToken()
     * @param \StructType\JP_ExtendedHotelInfo[] $hotel
     * @param int $page
     * @param int $recordsPerPage
     * @param int $totalPages
     * @param int $totalRecords
     * @param string $nextToken
     */
    public function __construct(array $hotel = array(), $page = null, $recordsPerPage = null, $totalPages = null, $totalRecords = null, $nextToken = null)
    {
        $this
            ->setHotel($hotel)
            ->setPage($page)
            ->setRecordsPerPage($recordsPerPage)
            ->setTotalPages($totalPages)
            ->setTotalRecords($totalRecords)
            ->setNextToken($nextToken);
    }
    /**
     * Get Hotel value
     * @return \StructType\JP_ExtendedHotelInfo[]|null
     */
    public function getHotel()
    {
        return $this->Hotel;
    }
    /**
     * This method is responsible for validating the values passed to the setHotel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelForArrayConstraintsFromSetHotel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_AccommodationPortfolioHotelItem) {
            // validation for constraint: itemType
            if (!$jP_AccommodationPortfolioHotelItem instanceof \StructType\JP_ExtendedHotelInfo) {
                $invalidValues[] = is_object($jP_AccommodationPortfolioHotelItem) ? get_class($jP_AccommodationPortfolioHotelItem) : sprintf('%s(%s)', gettype($jP_AccommodationPortfolioHotelItem), var_export($jP_AccommodationPortfolioHotelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Hotel property can only contain items of type \StructType\JP_ExtendedHotelInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ExtendedHotelInfo[] $hotel
     * @return \StructType\JP_AccommodationPortfolio
     */
    public function setHotel(array $hotel = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelArrayErrorMessage = self::validateHotelForArrayConstraintsFromSetHotel($hotel))) {
            throw new \InvalidArgumentException($hotelArrayErrorMessage, __LINE__);
        }
        $this->Hotel = $hotel;
        return $this;
    }
    /**
     * Add item to Hotel value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ExtendedHotelInfo $item
     * @return \StructType\JP_AccommodationPortfolio
     */
    public function addToHotel(\StructType\JP_ExtendedHotelInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ExtendedHotelInfo) {
            throw new \InvalidArgumentException(sprintf('The Hotel property can only contain items of type \StructType\JP_ExtendedHotelInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Hotel[] = $item;
        return $this;
    }
    /**
     * Get Page value
     * @return int|null
     */
    public function getPage()
    {
        return $this->Page;
    }
    /**
     * Set Page value
     * @param int $page
     * @return \StructType\JP_AccommodationPortfolio
     */
    public function setPage($page = null)
    {
        // validation for constraint: int
        if (!is_null($page) && !(is_int($page) || ctype_digit($page))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page, true), gettype($page)), __LINE__);
        }
        $this->Page = $page;
        return $this;
    }
    /**
     * Get RecordsPerPage value
     * @return int|null
     */
    public function getRecordsPerPage()
    {
        return $this->RecordsPerPage;
    }
    /**
     * Set RecordsPerPage value
     * @param int $recordsPerPage
     * @return \StructType\JP_AccommodationPortfolio
     */
    public function setRecordsPerPage($recordsPerPage = null)
    {
        // validation for constraint: int
        if (!is_null($recordsPerPage) && !(is_int($recordsPerPage) || ctype_digit($recordsPerPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordsPerPage, true), gettype($recordsPerPage)), __LINE__);
        }
        $this->RecordsPerPage = $recordsPerPage;
        return $this;
    }
    /**
     * Get TotalPages value
     * @return int|null
     */
    public function getTotalPages()
    {
        return $this->TotalPages;
    }
    /**
     * Set TotalPages value
     * @param int $totalPages
     * @return \StructType\JP_AccommodationPortfolio
     */
    public function setTotalPages($totalPages = null)
    {
        // validation for constraint: int
        if (!is_null($totalPages) && !(is_int($totalPages) || ctype_digit($totalPages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPages, true), gettype($totalPages)), __LINE__);
        }
        $this->TotalPages = $totalPages;
        return $this;
    }
    /**
     * Get TotalRecords value
     * @return int|null
     */
    public function getTotalRecords()
    {
        return $this->TotalRecords;
    }
    /**
     * Set TotalRecords value
     * @param int $totalRecords
     * @return \StructType\JP_AccommodationPortfolio
     */
    public function setTotalRecords($totalRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalRecords) && !(is_int($totalRecords) || ctype_digit($totalRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRecords, true), gettype($totalRecords)), __LINE__);
        }
        $this->TotalRecords = $totalRecords;
        return $this;
    }
    /**
     * Get NextToken value
     * @return string|null
     */
    public function getNextToken()
    {
        return $this->NextToken;
    }
    /**
     * Set NextToken value
     * @param string $nextToken
     * @return \StructType\JP_AccommodationPortfolio
     */
    public function setNextToken($nextToken = null)
    {
        // validation for constraint: string
        if (!is_null($nextToken) && !is_string($nextToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nextToken, true), gettype($nextToken)), __LINE__);
        }
        $this->NextToken = $nextToken;
        return $this;
    }
}
