<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SearchSegmentServices StructType
 * @subpackage Structs
 */
class JP_SearchSegmentServices extends JP_SearchSegmentBase
{
    /**
     * The Suppliers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Suppliers
     */
    public $Suppliers;
    /**
     * The ServiceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceName;
    /**
     * The ServiceCodes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString7
     */
    public $ServiceCodes;
    /**
     * The OnlyResident
     * @var bool
     */
    public $OnlyResident;
    /**
     * The Type
     * @var int
     */
    public $Type;
    /**
     * The Class
     * @var int
     */
    public $Class;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The OptionCode
     * @var string
     */
    public $OptionCode;
    /**
     * The InternalSupplier
     * @var int
     */
    public $InternalSupplier;
    /**
     * Constructor method for JP_SearchSegmentServices
     * @uses JP_SearchSegmentServices::setSuppliers()
     * @uses JP_SearchSegmentServices::setServiceName()
     * @uses JP_SearchSegmentServices::setServiceCodes()
     * @uses JP_SearchSegmentServices::setOnlyResident()
     * @uses JP_SearchSegmentServices::setType()
     * @uses JP_SearchSegmentServices::setClass()
     * @uses JP_SearchSegmentServices::setCode()
     * @uses JP_SearchSegmentServices::setOptionCode()
     * @uses JP_SearchSegmentServices::setInternalSupplier()
     * @param \StructType\JP_Suppliers $suppliers
     * @param string $serviceName
     * @param \ArrayType\ArrayOfString7 $serviceCodes
     * @param bool $onlyResident
     * @param int $type
     * @param int $class
     * @param string $code
     * @param string $optionCode
     * @param int $internalSupplier
     */
    public function __construct(\StructType\JP_Suppliers $suppliers = null, $serviceName = null, \ArrayType\ArrayOfString7 $serviceCodes = null, $onlyResident = null, $type = null, $class = null, $code = null, $optionCode = null, $internalSupplier = null)
    {
        $this
            ->setSuppliers($suppliers)
            ->setServiceName($serviceName)
            ->setServiceCodes($serviceCodes)
            ->setOnlyResident($onlyResident)
            ->setType($type)
            ->setClass($class)
            ->setCode($code)
            ->setOptionCode($optionCode)
            ->setInternalSupplier($internalSupplier);
    }
    /**
     * Get Suppliers value
     * @return \StructType\JP_Suppliers|null
     */
    public function getSuppliers()
    {
        return $this->Suppliers;
    }
    /**
     * Set Suppliers value
     * @param \StructType\JP_Suppliers $suppliers
     * @return \StructType\JP_SearchSegmentServices
     */
    public function setSuppliers(\StructType\JP_Suppliers $suppliers = null)
    {
        $this->Suppliers = $suppliers;
        return $this;
    }
    /**
     * Get ServiceName value
     * @return string|null
     */
    public function getServiceName()
    {
        return $this->ServiceName;
    }
    /**
     * Set ServiceName value
     * @param string $serviceName
     * @return \StructType\JP_SearchSegmentServices
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceName, true), gettype($serviceName)), __LINE__);
        }
        $this->ServiceName = $serviceName;
        return $this;
    }
    /**
     * Get ServiceCodes value
     * @return \ArrayType\ArrayOfString7|null
     */
    public function getServiceCodes()
    {
        return $this->ServiceCodes;
    }
    /**
     * Set ServiceCodes value
     * @param \ArrayType\ArrayOfString7 $serviceCodes
     * @return \StructType\JP_SearchSegmentServices
     */
    public function setServiceCodes(\ArrayType\ArrayOfString7 $serviceCodes = null)
    {
        $this->ServiceCodes = $serviceCodes;
        return $this;
    }
    /**
     * Get OnlyResident value
     * @return bool|null
     */
    public function getOnlyResident()
    {
        return $this->OnlyResident;
    }
    /**
     * Set OnlyResident value
     * @param bool $onlyResident
     * @return \StructType\JP_SearchSegmentServices
     */
    public function setOnlyResident($onlyResident = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyResident) && !is_bool($onlyResident)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyResident, true), gettype($onlyResident)), __LINE__);
        }
        $this->OnlyResident = $onlyResident;
        return $this;
    }
    /**
     * Get Type value
     * @return int|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param int $type
     * @return \StructType\JP_SearchSegmentServices
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Class value
     * @return int|null
     */
    public function getClass()
    {
        return $this->Class;
    }
    /**
     * Set Class value
     * @param int $class
     * @return \StructType\JP_SearchSegmentServices
     */
    public function setClass($class = null)
    {
        // validation for constraint: int
        if (!is_null($class) && !(is_int($class) || ctype_digit($class))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($class, true), gettype($class)), __LINE__);
        }
        $this->Class = $class;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_SearchSegmentServices
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get OptionCode value
     * @return string|null
     */
    public function getOptionCode()
    {
        return $this->OptionCode;
    }
    /**
     * Set OptionCode value
     * @param string $optionCode
     * @return \StructType\JP_SearchSegmentServices
     */
    public function setOptionCode($optionCode = null)
    {
        // validation for constraint: string
        if (!is_null($optionCode) && !is_string($optionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optionCode, true), gettype($optionCode)), __LINE__);
        }
        $this->OptionCode = $optionCode;
        return $this;
    }
    /**
     * Get InternalSupplier value
     * @return int|null
     */
    public function getInternalSupplier()
    {
        return $this->InternalSupplier;
    }
    /**
     * Set InternalSupplier value
     * @param int $internalSupplier
     * @return \StructType\JP_SearchSegmentServices
     */
    public function setInternalSupplier($internalSupplier = null)
    {
        // validation for constraint: int
        if (!is_null($internalSupplier) && !(is_int($internalSupplier) || ctype_digit($internalSupplier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($internalSupplier, true), gettype($internalSupplier)), __LINE__);
        }
        $this->InternalSupplier = $internalSupplier;
        return $this;
    }
}
