<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceAvailabilityRQ StructType
 * @subpackage Structs
 */
class JP_ServiceAvailabilityRQ extends AbstractStructBase
{
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The Paxes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Paxes
     */
    public $Paxes;
    /**
     * The ServiceRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServiceRequest
     */
    public $ServiceRequest;
    /**
     * The AdvancedOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServicesAvailAdvancedOptions
     */
    public $AdvancedOptions;
    /**
     * The RestrictedOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * Constructor method for JP_ServiceAvailabilityRQ
     * @uses JP_ServiceAvailabilityRQ::setLogin()
     * @uses JP_ServiceAvailabilityRQ::setPaxes()
     * @uses JP_ServiceAvailabilityRQ::setServiceRequest()
     * @uses JP_ServiceAvailabilityRQ::setAdvancedOptions()
     * @uses JP_ServiceAvailabilityRQ::setRestrictedOptions()
     * @uses JP_ServiceAvailabilityRQ::setVersion()
     * @uses JP_ServiceAvailabilityRQ::setLanguage()
     * @uses JP_ServiceAvailabilityRQ::setTimeStamp()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_Paxes $paxes
     * @param \StructType\JP_ServiceRequest $serviceRequest
     * @param \StructType\JP_ServicesAvailAdvancedOptions $advancedOptions
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $version
     * @param string $language
     * @param string $timeStamp
     */
    public function __construct(\StructType\JP_Login $login = null, \StructType\JP_Paxes $paxes = null, \StructType\JP_ServiceRequest $serviceRequest = null, \StructType\JP_ServicesAvailAdvancedOptions $advancedOptions = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, $version = null, $language = null, $timeStamp = null)
    {
        $this
            ->setLogin($login)
            ->setPaxes($paxes)
            ->setServiceRequest($serviceRequest)
            ->setAdvancedOptions($advancedOptions)
            ->setRestrictedOptions($restrictedOptions)
            ->setVersion($version)
            ->setLanguage($language)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_ServiceAvailabilityRQ
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get Paxes value
     * @return \StructType\JP_Paxes|null
     */
    public function getPaxes()
    {
        return $this->Paxes;
    }
    /**
     * Set Paxes value
     * @param \StructType\JP_Paxes $paxes
     * @return \StructType\JP_ServiceAvailabilityRQ
     */
    public function setPaxes(\StructType\JP_Paxes $paxes = null)
    {
        $this->Paxes = $paxes;
        return $this;
    }
    /**
     * Get ServiceRequest value
     * @return \StructType\JP_ServiceRequest|null
     */
    public function getServiceRequest()
    {
        return $this->ServiceRequest;
    }
    /**
     * Set ServiceRequest value
     * @param \StructType\JP_ServiceRequest $serviceRequest
     * @return \StructType\JP_ServiceAvailabilityRQ
     */
    public function setServiceRequest(\StructType\JP_ServiceRequest $serviceRequest = null)
    {
        $this->ServiceRequest = $serviceRequest;
        return $this;
    }
    /**
     * Get AdvancedOptions value
     * @return \StructType\JP_ServicesAvailAdvancedOptions|null
     */
    public function getAdvancedOptions()
    {
        return $this->AdvancedOptions;
    }
    /**
     * Set AdvancedOptions value
     * @param \StructType\JP_ServicesAvailAdvancedOptions $advancedOptions
     * @return \StructType\JP_ServiceAvailabilityRQ
     */
    public function setAdvancedOptions(\StructType\JP_ServicesAvailAdvancedOptions $advancedOptions = null)
    {
        $this->AdvancedOptions = $advancedOptions;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_ServiceAvailabilityRQ
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_ServiceAvailabilityRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_ServiceAvailabilityRQ
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\JP_ServiceAvailabilityRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
}
