<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SearchPreSegmentCruise StructType
 * @subpackage Structs
 */
class JP_SearchPreSegmentCruise extends AbstractStructBase
{
    /**
     * The CountryOfResidence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryOfResidence;
    /**
     * The ShipCode
     * @var string
     */
    public $ShipCode;
    /**
     * The Zone
     * @var int
     */
    public $Zone;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The IncludeFlight
     * @var bool
     */
    public $IncludeFlight;
    /**
     * Constructor method for JP_SearchPreSegmentCruise
     * @uses JP_SearchPreSegmentCruise::setCountryOfResidence()
     * @uses JP_SearchPreSegmentCruise::setShipCode()
     * @uses JP_SearchPreSegmentCruise::setZone()
     * @uses JP_SearchPreSegmentCruise::setStart()
     * @uses JP_SearchPreSegmentCruise::setEnd()
     * @uses JP_SearchPreSegmentCruise::setDuration()
     * @uses JP_SearchPreSegmentCruise::setIncludeFlight()
     * @param string $countryOfResidence
     * @param string $shipCode
     * @param int $zone
     * @param string $start
     * @param string $end
     * @param string $duration
     * @param bool $includeFlight
     */
    public function __construct($countryOfResidence = null, $shipCode = null, $zone = null, $start = null, $end = null, $duration = null, $includeFlight = null)
    {
        $this
            ->setCountryOfResidence($countryOfResidence)
            ->setShipCode($shipCode)
            ->setZone($zone)
            ->setStart($start)
            ->setEnd($end)
            ->setDuration($duration)
            ->setIncludeFlight($includeFlight);
    }
    /**
     * Get CountryOfResidence value
     * @return string|null
     */
    public function getCountryOfResidence()
    {
        return $this->CountryOfResidence;
    }
    /**
     * Set CountryOfResidence value
     * @param string $countryOfResidence
     * @return \StructType\JP_SearchPreSegmentCruise
     */
    public function setCountryOfResidence($countryOfResidence = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfResidence) && !is_string($countryOfResidence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfResidence, true), gettype($countryOfResidence)), __LINE__);
        }
        $this->CountryOfResidence = $countryOfResidence;
        return $this;
    }
    /**
     * Get ShipCode value
     * @return string|null
     */
    public function getShipCode()
    {
        return $this->ShipCode;
    }
    /**
     * Set ShipCode value
     * @param string $shipCode
     * @return \StructType\JP_SearchPreSegmentCruise
     */
    public function setShipCode($shipCode = null)
    {
        // validation for constraint: string
        if (!is_null($shipCode) && !is_string($shipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipCode, true), gettype($shipCode)), __LINE__);
        }
        $this->ShipCode = $shipCode;
        return $this;
    }
    /**
     * Get Zone value
     * @return int|null
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * Set Zone value
     * @param int $zone
     * @return \StructType\JP_SearchPreSegmentCruise
     */
    public function setZone($zone = null)
    {
        // validation for constraint: int
        if (!is_null($zone) && !(is_int($zone) || ctype_digit($zone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zone, true), gettype($zone)), __LINE__);
        }
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_SearchPreSegmentCruise
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_SearchPreSegmentCruise
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @uses \EnumType\JP_CruiseDuration::valueIsValid()
     * @uses \EnumType\JP_CruiseDuration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $duration
     * @return \StructType\JP_SearchPreSegmentCruise
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_CruiseDuration::valueIsValid($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_CruiseDuration', is_array($duration) ? implode(', ', $duration) : var_export($duration, true), implode(', ', \EnumType\JP_CruiseDuration::getValidValues())), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get IncludeFlight value
     * @return bool|null
     */
    public function getIncludeFlight()
    {
        return $this->IncludeFlight;
    }
    /**
     * Set IncludeFlight value
     * @param bool $includeFlight
     * @return \StructType\JP_SearchPreSegmentCruise
     */
    public function setIncludeFlight($includeFlight = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeFlight) && !is_bool($includeFlight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeFlight, true), gettype($includeFlight)), __LINE__);
        }
        $this->IncludeFlight = $includeFlight;
        return $this;
    }
}
