<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Equipment ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Equipment extends AbstractStructArrayBase
{
    /**
     * The Equipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Equipment[]
     */
    public $Equipment;
    /**
     * Constructor method for ArrayOfJP_Equipment
     * @uses ArrayOfJP_Equipment::setEquipment()
     * @param \StructType\JP_Equipment[] $equipment
     */
    public function __construct(array $equipment = array())
    {
        $this
            ->setEquipment($equipment);
    }
    /**
     * Get Equipment value
     * @return \StructType\JP_Equipment[]|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * This method is responsible for validating the values passed to the setEquipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEquipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEquipmentForArrayConstraintsFromSetEquipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_EquipmentEquipmentItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_EquipmentEquipmentItem instanceof \StructType\JP_Equipment) {
                $invalidValues[] = is_object($arrayOfJP_EquipmentEquipmentItem) ? get_class($arrayOfJP_EquipmentEquipmentItem) : sprintf('%s(%s)', gettype($arrayOfJP_EquipmentEquipmentItem), var_export($arrayOfJP_EquipmentEquipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Equipment property can only contain items of type \StructType\JP_Equipment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Equipment value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Equipment[] $equipment
     * @return \ArrayType\ArrayOfJP_Equipment
     */
    public function setEquipment(array $equipment = array())
    {
        // validation for constraint: array
        if ('' !== ($equipmentArrayErrorMessage = self::validateEquipmentForArrayConstraintsFromSetEquipment($equipment))) {
            throw new \InvalidArgumentException($equipmentArrayErrorMessage, __LINE__);
        }
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Add item to Equipment value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Equipment $item
     * @return \ArrayType\ArrayOfJP_Equipment
     */
    public function addToEquipment(\StructType\JP_Equipment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Equipment) {
            throw new \InvalidArgumentException(sprintf('The Equipment property can only contain items of type \StructType\JP_Equipment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Equipment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Equipment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Equipment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Equipment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Equipment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Equipment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Equipment
     */
    public function getAttributeName()
    {
        return 'Equipment';
    }
}
