<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Booking ServiceType
 * @subpackage Services
 */
class Booking extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BookingList
     * Meta information extracted from the WSDL
     * - documentation: Read process for Bookings Agency.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BookingList $parameters
     * @return \StructType\BookingListResponse|bool
     */
    public function BookingList(\StructType\BookingList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BookingList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BookingListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
