<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelBooking StructType
 * @subpackage Structs
 */
class JP_HotelBooking extends AbstractStructBase
{
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The Paxes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Paxes
     */
    public $Paxes;
    /**
     * The Holder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Holder
     */
    public $Holder;
    /**
     * The ReservationLocator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReservationLocator;
    /**
     * The ExternalBookingReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalBookingReference;
    /**
     * The FileNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileNumber;
    /**
     * The Agent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Agent
     */
    public $Agent;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Comment
     */
    public $Comments;
    /**
     * The Elements
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_HotelElement
     */
    public $Elements;
    /**
     * The AdvancedOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelBookingAdvancedOptions
     */
    public $AdvancedOptions;
    /**
     * The RestrictedOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * Constructor method for JP_HotelBooking
     * @uses JP_HotelBooking::setLogin()
     * @uses JP_HotelBooking::setPaxes()
     * @uses JP_HotelBooking::setHolder()
     * @uses JP_HotelBooking::setReservationLocator()
     * @uses JP_HotelBooking::setExternalBookingReference()
     * @uses JP_HotelBooking::setFileNumber()
     * @uses JP_HotelBooking::setAgent()
     * @uses JP_HotelBooking::setComments()
     * @uses JP_HotelBooking::setElements()
     * @uses JP_HotelBooking::setAdvancedOptions()
     * @uses JP_HotelBooking::setRestrictedOptions()
     * @uses JP_HotelBooking::setVersion()
     * @uses JP_HotelBooking::setLanguage()
     * @uses JP_HotelBooking::setTimeStamp()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_Paxes $paxes
     * @param \StructType\JP_Holder $holder
     * @param string $reservationLocator
     * @param string $externalBookingReference
     * @param string $fileNumber
     * @param \StructType\JP_Agent $agent
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @param \ArrayType\ArrayOfJP_HotelElement $elements
     * @param \StructType\JP_HotelBookingAdvancedOptions $advancedOptions
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $version
     * @param string $language
     * @param string $timeStamp
     */
    public function __construct(\StructType\JP_Login $login = null, \StructType\JP_Paxes $paxes = null, \StructType\JP_Holder $holder = null, $reservationLocator = null, $externalBookingReference = null, $fileNumber = null, \StructType\JP_Agent $agent = null, \ArrayType\ArrayOfJP_Comment $comments = null, \ArrayType\ArrayOfJP_HotelElement $elements = null, \StructType\JP_HotelBookingAdvancedOptions $advancedOptions = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, $version = null, $language = null, $timeStamp = null)
    {
        $this
            ->setLogin($login)
            ->setPaxes($paxes)
            ->setHolder($holder)
            ->setReservationLocator($reservationLocator)
            ->setExternalBookingReference($externalBookingReference)
            ->setFileNumber($fileNumber)
            ->setAgent($agent)
            ->setComments($comments)
            ->setElements($elements)
            ->setAdvancedOptions($advancedOptions)
            ->setRestrictedOptions($restrictedOptions)
            ->setVersion($version)
            ->setLanguage($language)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_HotelBooking
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get Paxes value
     * @return \StructType\JP_Paxes|null
     */
    public function getPaxes()
    {
        return $this->Paxes;
    }
    /**
     * Set Paxes value
     * @param \StructType\JP_Paxes $paxes
     * @return \StructType\JP_HotelBooking
     */
    public function setPaxes(\StructType\JP_Paxes $paxes = null)
    {
        $this->Paxes = $paxes;
        return $this;
    }
    /**
     * Get Holder value
     * @return \StructType\JP_Holder|null
     */
    public function getHolder()
    {
        return $this->Holder;
    }
    /**
     * Set Holder value
     * @param \StructType\JP_Holder $holder
     * @return \StructType\JP_HotelBooking
     */
    public function setHolder(\StructType\JP_Holder $holder = null)
    {
        $this->Holder = $holder;
        return $this;
    }
    /**
     * Get ReservationLocator value
     * @return string|null
     */
    public function getReservationLocator()
    {
        return $this->ReservationLocator;
    }
    /**
     * Set ReservationLocator value
     * @param string $reservationLocator
     * @return \StructType\JP_HotelBooking
     */
    public function setReservationLocator($reservationLocator = null)
    {
        // validation for constraint: string
        if (!is_null($reservationLocator) && !is_string($reservationLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationLocator, true), gettype($reservationLocator)), __LINE__);
        }
        $this->ReservationLocator = $reservationLocator;
        return $this;
    }
    /**
     * Get ExternalBookingReference value
     * @return string|null
     */
    public function getExternalBookingReference()
    {
        return $this->ExternalBookingReference;
    }
    /**
     * Set ExternalBookingReference value
     * @param string $externalBookingReference
     * @return \StructType\JP_HotelBooking
     */
    public function setExternalBookingReference($externalBookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalBookingReference) && !is_string($externalBookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalBookingReference, true), gettype($externalBookingReference)), __LINE__);
        }
        $this->ExternalBookingReference = $externalBookingReference;
        return $this;
    }
    /**
     * Get FileNumber value
     * @return string|null
     */
    public function getFileNumber()
    {
        return $this->FileNumber;
    }
    /**
     * Set FileNumber value
     * @param string $fileNumber
     * @return \StructType\JP_HotelBooking
     */
    public function setFileNumber($fileNumber = null)
    {
        // validation for constraint: string
        if (!is_null($fileNumber) && !is_string($fileNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileNumber, true), gettype($fileNumber)), __LINE__);
        }
        $this->FileNumber = $fileNumber;
        return $this;
    }
    /**
     * Get Agent value
     * @return \StructType\JP_Agent|null
     */
    public function getAgent()
    {
        return $this->Agent;
    }
    /**
     * Set Agent value
     * @param \StructType\JP_Agent $agent
     * @return \StructType\JP_HotelBooking
     */
    public function setAgent(\StructType\JP_Agent $agent = null)
    {
        $this->Agent = $agent;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfJP_Comment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @return \StructType\JP_HotelBooking
     */
    public function setComments(\ArrayType\ArrayOfJP_Comment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Elements value
     * @return \ArrayType\ArrayOfJP_HotelElement|null
     */
    public function getElements()
    {
        return $this->Elements;
    }
    /**
     * Set Elements value
     * @param \ArrayType\ArrayOfJP_HotelElement $elements
     * @return \StructType\JP_HotelBooking
     */
    public function setElements(\ArrayType\ArrayOfJP_HotelElement $elements = null)
    {
        $this->Elements = $elements;
        return $this;
    }
    /**
     * Get AdvancedOptions value
     * @return \StructType\JP_HotelBookingAdvancedOptions|null
     */
    public function getAdvancedOptions()
    {
        return $this->AdvancedOptions;
    }
    /**
     * Set AdvancedOptions value
     * @param \StructType\JP_HotelBookingAdvancedOptions $advancedOptions
     * @return \StructType\JP_HotelBooking
     */
    public function setAdvancedOptions(\StructType\JP_HotelBookingAdvancedOptions $advancedOptions = null)
    {
        $this->AdvancedOptions = $advancedOptions;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_HotelBooking
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_HotelBooking
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_HotelBooking
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\JP_HotelBooking
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
}
