<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransferContentInfo StructType
 * @subpackage Structs
 */
class JP_TransferContentInfo extends AbstractStructBase
{
    /**
     * The TransferName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransferName;
    /**
     * The Descriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Description
     */
    public $Descriptions;
    /**
     * The Images
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ImageLong
     */
    public $Images;
    /**
     * The Clasifications
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Clasification
     */
    public $Clasifications;
    /**
     * Constructor method for JP_TransferContentInfo
     * @uses JP_TransferContentInfo::setTransferName()
     * @uses JP_TransferContentInfo::setDescriptions()
     * @uses JP_TransferContentInfo::setImages()
     * @uses JP_TransferContentInfo::setClasifications()
     * @param string $transferName
     * @param \ArrayType\ArrayOfJP_Description $descriptions
     * @param \ArrayType\ArrayOfJP_ImageLong $images
     * @param \ArrayType\ArrayOfJP_Clasification $clasifications
     */
    public function __construct($transferName = null, \ArrayType\ArrayOfJP_Description $descriptions = null, \ArrayType\ArrayOfJP_ImageLong $images = null, \ArrayType\ArrayOfJP_Clasification $clasifications = null)
    {
        $this
            ->setTransferName($transferName)
            ->setDescriptions($descriptions)
            ->setImages($images)
            ->setClasifications($clasifications);
    }
    /**
     * Get TransferName value
     * @return string|null
     */
    public function getTransferName()
    {
        return $this->TransferName;
    }
    /**
     * Set TransferName value
     * @param string $transferName
     * @return \StructType\JP_TransferContentInfo
     */
    public function setTransferName($transferName = null)
    {
        // validation for constraint: string
        if (!is_null($transferName) && !is_string($transferName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transferName, true), gettype($transferName)), __LINE__);
        }
        $this->TransferName = $transferName;
        return $this;
    }
    /**
     * Get Descriptions value
     * @return \ArrayType\ArrayOfJP_Description|null
     */
    public function getDescriptions()
    {
        return $this->Descriptions;
    }
    /**
     * Set Descriptions value
     * @param \ArrayType\ArrayOfJP_Description $descriptions
     * @return \StructType\JP_TransferContentInfo
     */
    public function setDescriptions(\ArrayType\ArrayOfJP_Description $descriptions = null)
    {
        $this->Descriptions = $descriptions;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfJP_ImageLong|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfJP_ImageLong $images
     * @return \StructType\JP_TransferContentInfo
     */
    public function setImages(\ArrayType\ArrayOfJP_ImageLong $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get Clasifications value
     * @return \ArrayType\ArrayOfJP_Clasification|null
     */
    public function getClasifications()
    {
        return $this->Clasifications;
    }
    /**
     * Set Clasifications value
     * @param \ArrayType\ArrayOfJP_Clasification $clasifications
     * @return \StructType\JP_TransferContentInfo
     */
    public function setClasifications(\ArrayType\ArrayOfJP_Clasification $clasifications = null)
    {
        $this->Clasifications = $clasifications;
        return $this;
    }
}
