<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PackageAvailAdvancedOptions StructType
 * @subpackage Structs
 */
class JP_PackageAvailAdvancedOptions extends JP_AvailAdvancedOptions
{
    /**
     * The ShowOnlyAvailable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowOnlyAvailable;
    /**
     * The ShowCompleteInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowCompleteInfo;
    /**
     * Constructor method for JP_PackageAvailAdvancedOptions
     * @uses JP_PackageAvailAdvancedOptions::setShowOnlyAvailable()
     * @uses JP_PackageAvailAdvancedOptions::setShowCompleteInfo()
     * @param bool $showOnlyAvailable
     * @param bool $showCompleteInfo
     */
    public function __construct($showOnlyAvailable = null, $showCompleteInfo = null)
    {
        $this
            ->setShowOnlyAvailable($showOnlyAvailable)
            ->setShowCompleteInfo($showCompleteInfo);
    }
    /**
     * Get ShowOnlyAvailable value
     * @return bool|null
     */
    public function getShowOnlyAvailable()
    {
        return $this->ShowOnlyAvailable;
    }
    /**
     * Set ShowOnlyAvailable value
     * @param bool $showOnlyAvailable
     * @return \StructType\JP_PackageAvailAdvancedOptions
     */
    public function setShowOnlyAvailable($showOnlyAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($showOnlyAvailable) && !is_bool($showOnlyAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showOnlyAvailable, true), gettype($showOnlyAvailable)), __LINE__);
        }
        $this->ShowOnlyAvailable = $showOnlyAvailable;
        return $this;
    }
    /**
     * Get ShowCompleteInfo value
     * @return bool|null
     */
    public function getShowCompleteInfo()
    {
        return $this->ShowCompleteInfo;
    }
    /**
     * Set ShowCompleteInfo value
     * @param bool $showCompleteInfo
     * @return \StructType\JP_PackageAvailAdvancedOptions
     */
    public function setShowCompleteInfo($showCompleteInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($showCompleteInfo) && !is_bool($showCompleteInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showCompleteInfo, true), gettype($showCompleteInfo)), __LINE__);
        }
        $this->ShowCompleteInfo = $showCompleteInfo;
        return $this;
    }
}
