<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Document StructType
 * @subpackage Structs
 */
class Document extends AbstractStructBase
{
    /**
     * The binaryDocument
     * @var string
     */
    public $binaryDocument;
    /**
     * The documentCorrect
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $documentCorrect;
    /**
     * The outputString
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $outputString;
    /**
     * Constructor method for Document
     * @uses Document::setBinaryDocument()
     * @uses Document::setDocumentCorrect()
     * @uses Document::setOutputString()
     * @param string $binaryDocument
     * @param bool $documentCorrect
     * @param string $outputString
     */
    public function __construct($binaryDocument = null, $documentCorrect = null, $outputString = null)
    {
        $this
            ->setBinaryDocument($binaryDocument)
            ->setDocumentCorrect($documentCorrect)
            ->setOutputString($outputString);
    }
    /**
     * Get binaryDocument value
     * @return string|null
     */
    public function getBinaryDocument()
    {
        return $this->binaryDocument;
    }
    /**
     * Set binaryDocument value
     * @param string $binaryDocument
     * @return Document
     */
    public function setBinaryDocument($binaryDocument = null)
    {
        // validation for constraint: string
        if (!is_null($binaryDocument) && !is_string($binaryDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($binaryDocument)), __LINE__);
        }
        $this->binaryDocument = $binaryDocument;
        return $this;
    }
    /**
     * Get documentCorrect value
     * @return bool|null
     */
    public function getDocumentCorrect()
    {
        return $this->documentCorrect;
    }
    /**
     * Set documentCorrect value
     * @param bool $documentCorrect
     * @return Document
     */
    public function setDocumentCorrect($documentCorrect = null)
    {
        // validation for constraint: boolean
        if (!is_null($documentCorrect) && !is_bool($documentCorrect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($documentCorrect)), __LINE__);
        }
        $this->documentCorrect = $documentCorrect;
        return $this;
    }
    /**
     * Get outputString value
     * @return string|null
     */
    public function getOutputString()
    {
        return $this->outputString;
    }
    /**
     * Set outputString value
     * @param string $outputString
     * @return Document
     */
    public function setOutputString($outputString = null)
    {
        // validation for constraint: string
        if (!is_null($outputString) && !is_string($outputString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($outputString)), __LINE__);
        }
        $this->outputString = $outputString;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return Document
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
