<?php

namespace Sabre\DesignatePrinter\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticket Structs
 * @subpackage Structs
 */
class Ticket extends AbstractStructBase
{
    /**
     * The MiniItinerary
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\DesignatePrinter\Structs\MiniItinerary
     */
    public $MiniItinerary;
    /**
     * The Remote
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\DesignatePrinter\Structs\Remote
     */
    public $Remote;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CountryCode;
    /**
     * The LNIATA
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $LNIATA;
    /**
     * The Undesignate
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Undesignate;
    /**
     * Constructor method for Ticket
     * @uses Ticket::setMiniItinerary()
     * @uses Ticket::setRemote()
     * @uses Ticket::setCountryCode()
     * @uses Ticket::setLNIATA()
     * @uses Ticket::setUndesignate()
     * @param \Sabre\DesignatePrinter\Structs\MiniItinerary $miniItinerary
     * @param \Sabre\DesignatePrinter\Structs\Remote $remote
     * @param string $countryCode
     * @param string $lNIATA
     * @param bool $undesignate
     */
    public function __construct(\Sabre\DesignatePrinter\Structs\MiniItinerary $miniItinerary = null, \Sabre\DesignatePrinter\Structs\Remote $remote = null, $countryCode = null, $lNIATA = null, $undesignate = null)
    {
        $this
            ->setMiniItinerary($miniItinerary)
            ->setRemote($remote)
            ->setCountryCode($countryCode)
            ->setLNIATA($lNIATA)
            ->setUndesignate($undesignate);
    }
    /**
     * Get MiniItinerary value
     * @return \Sabre\DesignatePrinter\Structs\MiniItinerary|null
     */
    public function getMiniItinerary()
    {
        return $this->MiniItinerary;
    }
    /**
     * Set MiniItinerary value
     * @param \Sabre\DesignatePrinter\Structs\MiniItinerary $miniItinerary
     * @return \Sabre\DesignatePrinter\Structs\Ticket
     */
    public function setMiniItinerary(\Sabre\DesignatePrinter\Structs\MiniItinerary $miniItinerary = null)
    {
        $this->MiniItinerary = $miniItinerary;
        return $this;
    }
    /**
     * Get Remote value
     * @return \Sabre\DesignatePrinter\Structs\Remote|null
     */
    public function getRemote()
    {
        return $this->Remote;
    }
    /**
     * Set Remote value
     * @param \Sabre\DesignatePrinter\Structs\Remote $remote
     * @return \Sabre\DesignatePrinter\Structs\Ticket
     */
    public function setRemote(\Sabre\DesignatePrinter\Structs\Remote $remote = null)
    {
        $this->Remote = $remote;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \Sabre\DesignatePrinter\Structs\Ticket
     */
    public function setCountryCode($countryCode = null)
    {
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get LNIATA value
     * @return string|null
     */
    public function getLNIATA()
    {
        return $this->LNIATA;
    }
    /**
     * Set LNIATA value
     * @param string $lNIATA
     * @return \Sabre\DesignatePrinter\Structs\Ticket
     */
    public function setLNIATA($lNIATA = null)
    {
        $this->LNIATA = $lNIATA;
        return $this;
    }
    /**
     * Get Undesignate value
     * @return bool|null
     */
    public function getUndesignate()
    {
        return $this->Undesignate;
    }
    /**
     * Set Undesignate value
     * @param bool $undesignate
     * @return \Sabre\DesignatePrinter\Structs\Ticket
     */
    public function setUndesignate($undesignate = null)
    {
        $this->Undesignate = $undesignate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\DesignatePrinter\Structs\Ticket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
