<?php

namespace Sabre\DesignatePrinter\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Hardcopy Structs
 * @subpackage Structs
 */
class Hardcopy extends AbstractStructBase
{
    /**
     * The LNIATA
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $LNIATA;
    /**
     * The Spacing
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Spacing;
    /**
     * The Undesignate
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Undesignate;
    /**
     * Constructor method for Hardcopy
     * @uses Hardcopy::setLNIATA()
     * @uses Hardcopy::setSpacing()
     * @uses Hardcopy::setUndesignate()
     * @param string $lNIATA
     * @param string $spacing
     * @param bool $undesignate
     */
    public function __construct($lNIATA = null, $spacing = null, $undesignate = null)
    {
        $this
            ->setLNIATA($lNIATA)
            ->setSpacing($spacing)
            ->setUndesignate($undesignate);
    }
    /**
     * Get LNIATA value
     * @return string|null
     */
    public function getLNIATA()
    {
        return $this->LNIATA;
    }
    /**
     * Set LNIATA value
     * @param string $lNIATA
     * @return \Sabre\DesignatePrinter\Structs\Hardcopy
     */
    public function setLNIATA($lNIATA = null)
    {
        $this->LNIATA = $lNIATA;
        return $this;
    }
    /**
     * Get Spacing value
     * @return string|null
     */
    public function getSpacing()
    {
        return $this->Spacing;
    }
    /**
     * Set Spacing value
     * @param string $spacing
     * @return \Sabre\DesignatePrinter\Structs\Hardcopy
     */
    public function setSpacing($spacing = null)
    {
        $this->Spacing = $spacing;
        return $this;
    }
    /**
     * Get Undesignate value
     * @return bool|null
     */
    public function getUndesignate()
    {
        return $this->Undesignate;
    }
    /**
     * Set Undesignate value
     * @param bool $undesignate
     * @return \Sabre\DesignatePrinter\Structs\Hardcopy
     */
    public function setUndesignate($undesignate = null)
    {
        $this->Undesignate = $undesignate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\DesignatePrinter\Structs\Hardcopy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
