<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VideoDescriptionType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Describes a video item.
 * @subpackage Structs
 */
class VideoDescriptionType extends AbstractStructBase
{
    /**
     * The VideoFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\VideoFormat[]
     */
    public $VideoFormat;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the video category. Refer to OpenTravel Code list Picture Category Code (PIC).
     * - use: optional
     * @var string
     */
    public $Category;
    /**
     * Constructor method for VideoDescriptionType
     * @uses VideoDescriptionType::setVideoFormat()
     * @uses VideoDescriptionType::setCategory()
     * @param \Sabre\OTAPing\Structs\VideoFormat[] $videoFormat
     * @param string $category
     */
    public function __construct(array $videoFormat = array(), $category = null)
    {
        $this
            ->setVideoFormat($videoFormat)
            ->setCategory($category);
    }
    /**
     * Get VideoFormat value
     * @return \Sabre\OTAPing\Structs\VideoFormat[]|null
     */
    public function getVideoFormat()
    {
        return $this->VideoFormat;
    }
    /**
     * Set VideoFormat value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\VideoFormat[] $videoFormat
     * @return \Sabre\OTAPing\Structs\VideoDescriptionType
     */
    public function setVideoFormat(array $videoFormat = array())
    {
        $this->VideoFormat = $videoFormat;
        return $this;
    }
    /**
     * Add item to VideoFormat value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\VideoFormat $item
     * @return \Sabre\OTAPing\Structs\VideoDescriptionType
     */
    public function addToVideoFormat(\Sabre\OTAPing\Structs\VideoFormat $item)
    {
        $this->VideoFormat[] = $item;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \Sabre\OTAPing\Structs\VideoDescriptionType
     */
    public function setCategory($category = null)
    {
        $this->Category = $category;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\VideoDescriptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
