<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerificationType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Collection of data used to ensure the correct reservation is canceled or modified (e.g. in the case of a hotel reservation modification, a CustLoyalty/ MembershipID would be verified as part of the reservation that you plan to modify
 * to ensure the correct reservation is being modified).
 * @subpackage Structs
 */
class VerificationType extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\PersonName
     */
    public $PersonName;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - documentation: Information on an email address.
     * - minOccurs: 0
     * @var mixed
     */
    public $Email;
    /**
     * The TelephoneInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\TelephoneInfo
     */
    public $TelephoneInfo;
    /**
     * The PaymentCard
     * Meta informations extracted from the WSDL
     * - documentation: Payment Card information.
     * - minOccurs: 0
     * @var mixed
     */
    public $PaymentCard;
    /**
     * The AddressInfo
     * Meta informations extracted from the WSDL
     * - documentation: Detailed information on an address.
     * - minOccurs: 0
     * @var mixed
     */
    public $AddressInfo;
    /**
     * The CustLoyalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - documentation: Vendor or vendors associated with the reservation.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Vendor;
    /**
     * The ReservationTimeSpan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\ReservationTimeSpan
     */
    public $ReservationTimeSpan;
    /**
     * The AssociatedQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\AssociatedQuantity[]
     */
    public $AssociatedQuantity;
    /**
     * The StartLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\StartLocation
     */
    public $StartLocation;
    /**
     * The EndLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\EndLocation
     */
    public $EndLocation;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * Constructor method for VerificationType
     * @uses VerificationType::setPersonName()
     * @uses VerificationType::setEmail()
     * @uses VerificationType::setTelephoneInfo()
     * @uses VerificationType::setPaymentCard()
     * @uses VerificationType::setAddressInfo()
     * @uses VerificationType::setCustLoyalty()
     * @uses VerificationType::setVendor()
     * @uses VerificationType::setReservationTimeSpan()
     * @uses VerificationType::setAssociatedQuantity()
     * @uses VerificationType::setStartLocation()
     * @uses VerificationType::setEndLocation()
     * @uses VerificationType::setTPA_Extensions()
     * @param \Sabre\OTAPing\Structs\PersonName $personName
     * @param mixed $email
     * @param \Sabre\OTAPing\Structs\TelephoneInfo $telephoneInfo
     * @param mixed $paymentCard
     * @param mixed $addressInfo
     * @param \Sabre\OTAPing\Structs\CustLoyalty[] $custLoyalty
     * @param mixed[] $vendor
     * @param \Sabre\OTAPing\Structs\ReservationTimeSpan $reservationTimeSpan
     * @param \Sabre\OTAPing\Structs\AssociatedQuantity[] $associatedQuantity
     * @param \Sabre\OTAPing\Structs\StartLocation $startLocation
     * @param \Sabre\OTAPing\Structs\EndLocation $endLocation
     * @param mixed $tPA_Extensions
     */
    public function __construct(\Sabre\OTAPing\Structs\PersonName $personName = null, $email = null, \Sabre\OTAPing\Structs\TelephoneInfo $telephoneInfo = null, $paymentCard = null, $addressInfo = null, array $custLoyalty = array(), array $vendor = array(), \Sabre\OTAPing\Structs\ReservationTimeSpan $reservationTimeSpan = null, array $associatedQuantity = array(), \Sabre\OTAPing\Structs\StartLocation $startLocation = null, \Sabre\OTAPing\Structs\EndLocation $endLocation = null, $tPA_Extensions = null)
    {
        $this
            ->setPersonName($personName)
            ->setEmail($email)
            ->setTelephoneInfo($telephoneInfo)
            ->setPaymentCard($paymentCard)
            ->setAddressInfo($addressInfo)
            ->setCustLoyalty($custLoyalty)
            ->setVendor($vendor)
            ->setReservationTimeSpan($reservationTimeSpan)
            ->setAssociatedQuantity($associatedQuantity)
            ->setStartLocation($startLocation)
            ->setEndLocation($endLocation)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get PersonName value
     * @return \Sabre\OTAPing\Structs\PersonName|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \Sabre\OTAPing\Structs\PersonName $personName
     * @return \Sabre\OTAPing\Structs\VerificationType
     */
    public function setPersonName(\Sabre\OTAPing\Structs\PersonName $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Email value
     * @return mixed|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param mixed $email
     * @return \Sabre\OTAPing\Structs\VerificationType
     */
    public function setEmail($email = null)
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Get TelephoneInfo value
     * @return \Sabre\OTAPing\Structs\TelephoneInfo|null
     */
    public function getTelephoneInfo()
    {
        return $this->TelephoneInfo;
    }
    /**
     * Set TelephoneInfo value
     * @param \Sabre\OTAPing\Structs\TelephoneInfo $telephoneInfo
     * @return \Sabre\OTAPing\Structs\VerificationType
     */
    public function setTelephoneInfo(\Sabre\OTAPing\Structs\TelephoneInfo $telephoneInfo = null)
    {
        $this->TelephoneInfo = $telephoneInfo;
        return $this;
    }
    /**
     * Get PaymentCard value
     * @return mixed|null
     */
    public function getPaymentCard()
    {
        return $this->PaymentCard;
    }
    /**
     * Set PaymentCard value
     * @param mixed $paymentCard
     * @return \Sabre\OTAPing\Structs\VerificationType
     */
    public function setPaymentCard($paymentCard = null)
    {
        $this->PaymentCard = $paymentCard;
        return $this;
    }
    /**
     * Get AddressInfo value
     * @return mixed|null
     */
    public function getAddressInfo()
    {
        return $this->AddressInfo;
    }
    /**
     * Set AddressInfo value
     * @param mixed $addressInfo
     * @return \Sabre\OTAPing\Structs\VerificationType
     */
    public function setAddressInfo($addressInfo = null)
    {
        $this->AddressInfo = $addressInfo;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \Sabre\OTAPing\Structs\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\CustLoyalty[] $custLoyalty
     * @return \Sabre\OTAPing\Structs\VerificationType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\CustLoyalty $item
     * @return \Sabre\OTAPing\Structs\VerificationType
     */
    public function addToCustLoyalty(\Sabre\OTAPing\Structs\CustLoyalty $item)
    {
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get Vendor value
     * @return mixed[]|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @throws \InvalidArgumentException
     * @param mixed[] $vendor
     * @return \Sabre\OTAPing\Structs\VerificationType
     */
    public function setVendor(array $vendor = array())
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Add item to Vendor value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \Sabre\OTAPing\Structs\VerificationType
     */
    public function addToVendor($item)
    {
        $this->Vendor[] = $item;
        return $this;
    }
    /**
     * Get ReservationTimeSpan value
     * @return \Sabre\OTAPing\Structs\ReservationTimeSpan|null
     */
    public function getReservationTimeSpan()
    {
        return $this->ReservationTimeSpan;
    }
    /**
     * Set ReservationTimeSpan value
     * @param \Sabre\OTAPing\Structs\ReservationTimeSpan $reservationTimeSpan
     * @return \Sabre\OTAPing\Structs\VerificationType
     */
    public function setReservationTimeSpan(\Sabre\OTAPing\Structs\ReservationTimeSpan $reservationTimeSpan = null)
    {
        $this->ReservationTimeSpan = $reservationTimeSpan;
        return $this;
    }
    /**
     * Get AssociatedQuantity value
     * @return \Sabre\OTAPing\Structs\AssociatedQuantity[]|null
     */
    public function getAssociatedQuantity()
    {
        return $this->AssociatedQuantity;
    }
    /**
     * Set AssociatedQuantity value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\AssociatedQuantity[] $associatedQuantity
     * @return \Sabre\OTAPing\Structs\VerificationType
     */
    public function setAssociatedQuantity(array $associatedQuantity = array())
    {
        $this->AssociatedQuantity = $associatedQuantity;
        return $this;
    }
    /**
     * Add item to AssociatedQuantity value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\AssociatedQuantity $item
     * @return \Sabre\OTAPing\Structs\VerificationType
     */
    public function addToAssociatedQuantity(\Sabre\OTAPing\Structs\AssociatedQuantity $item)
    {
        $this->AssociatedQuantity[] = $item;
        return $this;
    }
    /**
     * Get StartLocation value
     * @return \Sabre\OTAPing\Structs\StartLocation|null
     */
    public function getStartLocation()
    {
        return $this->StartLocation;
    }
    /**
     * Set StartLocation value
     * @param \Sabre\OTAPing\Structs\StartLocation $startLocation
     * @return \Sabre\OTAPing\Structs\VerificationType
     */
    public function setStartLocation(\Sabre\OTAPing\Structs\StartLocation $startLocation = null)
    {
        $this->StartLocation = $startLocation;
        return $this;
    }
    /**
     * Get EndLocation value
     * @return \Sabre\OTAPing\Structs\EndLocation|null
     */
    public function getEndLocation()
    {
        return $this->EndLocation;
    }
    /**
     * Set EndLocation value
     * @param \Sabre\OTAPing\Structs\EndLocation $endLocation
     * @return \Sabre\OTAPing\Structs\VerificationType
     */
    public function setEndLocation(\Sabre\OTAPing\Structs\EndLocation $endLocation = null)
    {
        $this->EndLocation = $endLocation;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \Sabre\OTAPing\Structs\VerificationType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\VerificationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
