<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Applicable tax element. This element allows for both percentages and flat amounts. If one field is used, the other should be zero since logically, taxes should be calculated in only one of the two ways. | Provides details of the tax.
 * | Provides the effective and expiry dates for the tax. | Specifies charge information by unit (e.g., room, person, item) and frequency (e.g., daily, weekly, stay).
 * @subpackage Structs
 */
class TaxType extends AbstractStructBase
{
    /**
     * The TaxDescription
     * Meta informations extracted from the WSDL
     * - documentation: Text description of the taxes in a given language.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $TaxDescription;
    /**
     * Constructor method for TaxType
     * @uses TaxType::setTaxDescription()
     * @param mixed[] $taxDescription
     */
    public function __construct(array $taxDescription = array())
    {
        $this
            ->setTaxDescription($taxDescription);
    }
    /**
     * Get TaxDescription value
     * @return mixed[]|null
     */
    public function getTaxDescription()
    {
        return $this->TaxDescription;
    }
    /**
     * Set TaxDescription value
     * @throws \InvalidArgumentException
     * @param mixed[] $taxDescription
     * @return \Sabre\OTAPing\Structs\TaxType
     */
    public function setTaxDescription(array $taxDescription = array())
    {
        $this->TaxDescription = $taxDescription;
        return $this;
    }
    /**
     * Add item to TaxDescription value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \Sabre\OTAPing\Structs\TaxType
     */
    public function addToTaxDescription($item)
    {
        $this->TaxDescription[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\TaxType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
