<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SourceType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Provides information on the source of a request.
 * @subpackage Structs
 */
class SourceType extends AbstractStructBase
{
    /**
     * The RequestorID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\RequestorID
     */
    public $RequestorID;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\Position
     */
    public $Position;
    /**
     * The BookingChannel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\BookingChannel
     */
    public $BookingChannel;
    /**
     * The AgentSine
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the party within the requesting entity.
     * - use: optional
     * @var string
     */
    public $AgentSine;
    /**
     * The PseudoCityCode
     * Meta informations extracted from the WSDL
     * - documentation: An identification code assigned to an office/agency by a reservation system.
     * - use: optional
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The ISOCountry
     * Meta informations extracted from the WSDL
     * - documentation: The country code of the requesting party.
     * - use: optional
     * @var string
     */
    public $ISOCountry;
    /**
     * The ISOCurrency
     * Meta informations extracted from the WSDL
     * - documentation: The currency code in which the reservation will be ticketed.
     * - use: optional
     * @var string
     */
    public $ISOCurrency;
    /**
     * The AgentDutyCode
     * Meta informations extracted from the WSDL
     * - documentation: An authority code assigned to a requestor.
     * - use: optional
     * @var string
     */
    public $AgentDutyCode;
    /**
     * The AirlineVendorID
     * Meta informations extracted from the WSDL
     * - documentation: The IATA assigned airline code.
     * - use: optional
     * @var string
     */
    public $AirlineVendorID;
    /**
     * The AirportCode
     * Meta informations extracted from the WSDL
     * - documentation: The IATA assigned airport code.
     * - use: optional
     * @var string
     */
    public $AirportCode;
    /**
     * The FirstDepartPoint
     * Meta informations extracted from the WSDL
     * - documentation: The point of first departure in a trip.
     * - use: optional
     * @var string
     */
    public $FirstDepartPoint;
    /**
     * The ERSP_UserID
     * Meta informations extracted from the WSDL
     * - documentation: Electronic Reservation Service Provider (ERSP) assigned identifier used to identify the individual using the ERSP system.
     * - use: optional
     * @var string
     */
    public $ERSP_UserID;
    /**
     * The TerminalID
     * Meta informations extracted from the WSDL
     * - documentation: This is the electronic address of the device from which information is entered.
     * - use: optional
     * @var string
     */
    public $TerminalID;
    /**
     * Constructor method for SourceType
     * @uses SourceType::setRequestorID()
     * @uses SourceType::setPosition()
     * @uses SourceType::setBookingChannel()
     * @uses SourceType::setAgentSine()
     * @uses SourceType::setPseudoCityCode()
     * @uses SourceType::setISOCountry()
     * @uses SourceType::setISOCurrency()
     * @uses SourceType::setAgentDutyCode()
     * @uses SourceType::setAirlineVendorID()
     * @uses SourceType::setAirportCode()
     * @uses SourceType::setFirstDepartPoint()
     * @uses SourceType::setERSP_UserID()
     * @uses SourceType::setTerminalID()
     * @param \Sabre\OTAPing\Structs\RequestorID $requestorID
     * @param \Sabre\OTAPing\Structs\Position $position
     * @param \Sabre\OTAPing\Structs\BookingChannel $bookingChannel
     * @param string $agentSine
     * @param string $pseudoCityCode
     * @param string $iSOCountry
     * @param string $iSOCurrency
     * @param string $agentDutyCode
     * @param string $airlineVendorID
     * @param string $airportCode
     * @param string $firstDepartPoint
     * @param string $eRSP_UserID
     * @param string $terminalID
     */
    public function __construct(\Sabre\OTAPing\Structs\RequestorID $requestorID = null, \Sabre\OTAPing\Structs\Position $position = null, \Sabre\OTAPing\Structs\BookingChannel $bookingChannel = null, $agentSine = null, $pseudoCityCode = null, $iSOCountry = null, $iSOCurrency = null, $agentDutyCode = null, $airlineVendorID = null, $airportCode = null, $firstDepartPoint = null, $eRSP_UserID = null, $terminalID = null)
    {
        $this
            ->setRequestorID($requestorID)
            ->setPosition($position)
            ->setBookingChannel($bookingChannel)
            ->setAgentSine($agentSine)
            ->setPseudoCityCode($pseudoCityCode)
            ->setISOCountry($iSOCountry)
            ->setISOCurrency($iSOCurrency)
            ->setAgentDutyCode($agentDutyCode)
            ->setAirlineVendorID($airlineVendorID)
            ->setAirportCode($airportCode)
            ->setFirstDepartPoint($firstDepartPoint)
            ->setERSP_UserID($eRSP_UserID)
            ->setTerminalID($terminalID);
    }
    /**
     * Get RequestorID value
     * @return \Sabre\OTAPing\Structs\RequestorID|null
     */
    public function getRequestorID()
    {
        return $this->RequestorID;
    }
    /**
     * Set RequestorID value
     * @param \Sabre\OTAPing\Structs\RequestorID $requestorID
     * @return \Sabre\OTAPing\Structs\SourceType
     */
    public function setRequestorID(\Sabre\OTAPing\Structs\RequestorID $requestorID = null)
    {
        $this->RequestorID = $requestorID;
        return $this;
    }
    /**
     * Get Position value
     * @return \Sabre\OTAPing\Structs\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \Sabre\OTAPing\Structs\Position $position
     * @return \Sabre\OTAPing\Structs\SourceType
     */
    public function setPosition(\Sabre\OTAPing\Structs\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get BookingChannel value
     * @return \Sabre\OTAPing\Structs\BookingChannel|null
     */
    public function getBookingChannel()
    {
        return $this->BookingChannel;
    }
    /**
     * Set BookingChannel value
     * @param \Sabre\OTAPing\Structs\BookingChannel $bookingChannel
     * @return \Sabre\OTAPing\Structs\SourceType
     */
    public function setBookingChannel(\Sabre\OTAPing\Structs\BookingChannel $bookingChannel = null)
    {
        $this->BookingChannel = $bookingChannel;
        return $this;
    }
    /**
     * Get AgentSine value
     * @return string|null
     */
    public function getAgentSine()
    {
        return $this->AgentSine;
    }
    /**
     * Set AgentSine value
     * @param string $agentSine
     * @return \Sabre\OTAPing\Structs\SourceType
     */
    public function setAgentSine($agentSine = null)
    {
        $this->AgentSine = $agentSine;
        return $this;
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \Sabre\OTAPing\Structs\SourceType
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get ISOCountry value
     * @return string|null
     */
    public function getISOCountry()
    {
        return $this->ISOCountry;
    }
    /**
     * Set ISOCountry value
     * @param string $iSOCountry
     * @return \Sabre\OTAPing\Structs\SourceType
     */
    public function setISOCountry($iSOCountry = null)
    {
        $this->ISOCountry = $iSOCountry;
        return $this;
    }
    /**
     * Get ISOCurrency value
     * @return string|null
     */
    public function getISOCurrency()
    {
        return $this->ISOCurrency;
    }
    /**
     * Set ISOCurrency value
     * @param string $iSOCurrency
     * @return \Sabre\OTAPing\Structs\SourceType
     */
    public function setISOCurrency($iSOCurrency = null)
    {
        $this->ISOCurrency = $iSOCurrency;
        return $this;
    }
    /**
     * Get AgentDutyCode value
     * @return string|null
     */
    public function getAgentDutyCode()
    {
        return $this->AgentDutyCode;
    }
    /**
     * Set AgentDutyCode value
     * @param string $agentDutyCode
     * @return \Sabre\OTAPing\Structs\SourceType
     */
    public function setAgentDutyCode($agentDutyCode = null)
    {
        $this->AgentDutyCode = $agentDutyCode;
        return $this;
    }
    /**
     * Get AirlineVendorID value
     * @return string|null
     */
    public function getAirlineVendorID()
    {
        return $this->AirlineVendorID;
    }
    /**
     * Set AirlineVendorID value
     * @param string $airlineVendorID
     * @return \Sabre\OTAPing\Structs\SourceType
     */
    public function setAirlineVendorID($airlineVendorID = null)
    {
        $this->AirlineVendorID = $airlineVendorID;
        return $this;
    }
    /**
     * Get AirportCode value
     * @return string|null
     */
    public function getAirportCode()
    {
        return $this->AirportCode;
    }
    /**
     * Set AirportCode value
     * @param string $airportCode
     * @return \Sabre\OTAPing\Structs\SourceType
     */
    public function setAirportCode($airportCode = null)
    {
        $this->AirportCode = $airportCode;
        return $this;
    }
    /**
     * Get FirstDepartPoint value
     * @return string|null
     */
    public function getFirstDepartPoint()
    {
        return $this->FirstDepartPoint;
    }
    /**
     * Set FirstDepartPoint value
     * @param string $firstDepartPoint
     * @return \Sabre\OTAPing\Structs\SourceType
     */
    public function setFirstDepartPoint($firstDepartPoint = null)
    {
        $this->FirstDepartPoint = $firstDepartPoint;
        return $this;
    }
    /**
     * Get ERSP_UserID value
     * @return string|null
     */
    public function getERSP_UserID()
    {
        return $this->ERSP_UserID;
    }
    /**
     * Set ERSP_UserID value
     * @param string $eRSP_UserID
     * @return \Sabre\OTAPing\Structs\SourceType
     */
    public function setERSP_UserID($eRSP_UserID = null)
    {
        $this->ERSP_UserID = $eRSP_UserID;
        return $this;
    }
    /**
     * Get TerminalID value
     * @return string|null
     */
    public function getTerminalID()
    {
        return $this->TerminalID;
    }
    /**
     * Set TerminalID value
     * @param string $terminalID
     * @return \Sabre\OTAPing\Structs\SourceType
     */
    public function setTerminalID($terminalID = null)
    {
        $this->TerminalID = $terminalID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\SourceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
