<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Products Structs
 * Meta informations extracted from the WSDL
 * - documentation: A collection of products.
 * @subpackage Structs
 */
class Products extends AbstractStructBase
{
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\Product[]
     */
    public $Product;
    /**
     * Constructor method for Products
     * @uses Products::setProduct()
     * @param \Sabre\OTAPing\Structs\Product[] $product
     */
    public function __construct(array $product = array())
    {
        $this
            ->setProduct($product);
    }
    /**
     * Get Product value
     * @return \Sabre\OTAPing\Structs\Product[]|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\Product[] $product
     * @return \Sabre\OTAPing\Structs\Products
     */
    public function setProduct(array $product = array())
    {
        $this->Product = $product;
        return $this;
    }
    /**
     * Add item to Product value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\Product $item
     * @return \Sabre\OTAPing\Structs\Products
     */
    public function addToProduct(\Sabre\OTAPing\Structs\Product $item)
    {
        $this->Product[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\Products
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
