<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentFormType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Ways of providing funds and guarantees for travel by the individual. | Allows for control of the sharing of payment form data between parties.
 * @subpackage Structs
 */
class PaymentFormType extends AbstractStructBase
{
    /**
     * The PaymentCard
     * Meta informations extracted from the WSDL
     * - documentation: Details of a debit or credit card.
     * @var mixed
     */
    public $PaymentCard;
    /**
     * The BankAcct
     * Meta informations extracted from the WSDL
     * - documentation: Details of a bank account.
     * @var mixed
     */
    public $BankAcct;
    /**
     * The DirectBill
     * Meta informations extracted from the WSDL
     * - documentation: Details of a direct billing arrangement.
     * @var mixed
     */
    public $DirectBill;
    /**
     * The Voucher
     * @var \Sabre\OTAPing\Structs\Voucher
     */
    public $Voucher;
    /**
     * The LoyaltyRedemption
     * @var \Sabre\OTAPing\Structs\LoyaltyRedemption
     */
    public $LoyaltyRedemption;
    /**
     * The MiscChargeOrder
     * @var \Sabre\OTAPing\Structs\MiscChargeOrder
     */
    public $MiscChargeOrder;
    /**
     * The Ticket
     * @var \Sabre\OTAPing\Structs\Ticket
     */
    public $Ticket;
    /**
     * The Cash
     * @var \Sabre\OTAPing\Structs\Cash
     */
    public $Cash;
    /**
     * The CostCenterID
     * Meta informations extracted from the WSDL
     * - documentation: A reference to identify the billing department for allocating cost of travel to company account.
     * - use: optional
     * @var string
     */
    public $CostCenterID;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: Provides a reference to a specific form of payment.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The PaymentTransactionTypeCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PaymentTransactionTypeCode;
    /**
     * The GuaranteeIndicator
     * Meta informations extracted from the WSDL
     * - documentation: When true, indicates this represents a guarantee rather than a payment form.
     * - use: optional
     * @var bool
     */
    public $GuaranteeIndicator;
    /**
     * The GuaranteeTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Used to specify the method of guarantee. Refer to OpenTravel Code List Payment Type (PMT).
     * - use: optional
     * @var string
     */
    public $GuaranteeTypeCode;
    /**
     * The GuaranteeID
     * Meta informations extracted from the WSDL
     * - documentation: Provides the identifier as specified by the GuaranteeTypeCode (e.g., Corporate ID or IATA number).
     * - use: optional
     * @var string
     */
    public $GuaranteeID;
    /**
     * The Remark
     * Meta informations extracted from the WSDL
     * - documentation: A remark associated with the payment form.
     * - use: optional
     * @var string
     */
    public $Remark;
    /**
     * Constructor method for PaymentFormType
     * @uses PaymentFormType::setPaymentCard()
     * @uses PaymentFormType::setBankAcct()
     * @uses PaymentFormType::setDirectBill()
     * @uses PaymentFormType::setVoucher()
     * @uses PaymentFormType::setLoyaltyRedemption()
     * @uses PaymentFormType::setMiscChargeOrder()
     * @uses PaymentFormType::setTicket()
     * @uses PaymentFormType::setCash()
     * @uses PaymentFormType::setCostCenterID()
     * @uses PaymentFormType::setRPH()
     * @uses PaymentFormType::setPaymentTransactionTypeCode()
     * @uses PaymentFormType::setGuaranteeIndicator()
     * @uses PaymentFormType::setGuaranteeTypeCode()
     * @uses PaymentFormType::setGuaranteeID()
     * @uses PaymentFormType::setRemark()
     * @param mixed $paymentCard
     * @param mixed $bankAcct
     * @param mixed $directBill
     * @param \Sabre\OTAPing\Structs\Voucher $voucher
     * @param \Sabre\OTAPing\Structs\LoyaltyRedemption $loyaltyRedemption
     * @param \Sabre\OTAPing\Structs\MiscChargeOrder $miscChargeOrder
     * @param \Sabre\OTAPing\Structs\Ticket $ticket
     * @param \Sabre\OTAPing\Structs\Cash $cash
     * @param string $costCenterID
     * @param string $rPH
     * @param string $paymentTransactionTypeCode
     * @param bool $guaranteeIndicator
     * @param string $guaranteeTypeCode
     * @param string $guaranteeID
     * @param string $remark
     */
    public function __construct($paymentCard = null, $bankAcct = null, $directBill = null, \Sabre\OTAPing\Structs\Voucher $voucher = null, \Sabre\OTAPing\Structs\LoyaltyRedemption $loyaltyRedemption = null, \Sabre\OTAPing\Structs\MiscChargeOrder $miscChargeOrder = null, \Sabre\OTAPing\Structs\Ticket $ticket = null, \Sabre\OTAPing\Structs\Cash $cash = null, $costCenterID = null, $rPH = null, $paymentTransactionTypeCode = null, $guaranteeIndicator = null, $guaranteeTypeCode = null, $guaranteeID = null, $remark = null)
    {
        $this
            ->setPaymentCard($paymentCard)
            ->setBankAcct($bankAcct)
            ->setDirectBill($directBill)
            ->setVoucher($voucher)
            ->setLoyaltyRedemption($loyaltyRedemption)
            ->setMiscChargeOrder($miscChargeOrder)
            ->setTicket($ticket)
            ->setCash($cash)
            ->setCostCenterID($costCenterID)
            ->setRPH($rPH)
            ->setPaymentTransactionTypeCode($paymentTransactionTypeCode)
            ->setGuaranteeIndicator($guaranteeIndicator)
            ->setGuaranteeTypeCode($guaranteeTypeCode)
            ->setGuaranteeID($guaranteeID)
            ->setRemark($remark);
    }
    /**
     * Get PaymentCard value
     * @return mixed|null
     */
    public function getPaymentCard()
    {
        return $this->PaymentCard;
    }
    /**
     * Set PaymentCard value
     * @param mixed $paymentCard
     * @return \Sabre\OTAPing\Structs\PaymentFormType
     */
    public function setPaymentCard($paymentCard = null)
    {
        $this->PaymentCard = $paymentCard;
        return $this;
    }
    /**
     * Get BankAcct value
     * @return mixed|null
     */
    public function getBankAcct()
    {
        return $this->BankAcct;
    }
    /**
     * Set BankAcct value
     * @param mixed $bankAcct
     * @return \Sabre\OTAPing\Structs\PaymentFormType
     */
    public function setBankAcct($bankAcct = null)
    {
        $this->BankAcct = $bankAcct;
        return $this;
    }
    /**
     * Get DirectBill value
     * @return mixed|null
     */
    public function getDirectBill()
    {
        return $this->DirectBill;
    }
    /**
     * Set DirectBill value
     * @param mixed $directBill
     * @return \Sabre\OTAPing\Structs\PaymentFormType
     */
    public function setDirectBill($directBill = null)
    {
        $this->DirectBill = $directBill;
        return $this;
    }
    /**
     * Get Voucher value
     * @return \Sabre\OTAPing\Structs\Voucher|null
     */
    public function getVoucher()
    {
        return $this->Voucher;
    }
    /**
     * Set Voucher value
     * @param \Sabre\OTAPing\Structs\Voucher $voucher
     * @return \Sabre\OTAPing\Structs\PaymentFormType
     */
    public function setVoucher(\Sabre\OTAPing\Structs\Voucher $voucher = null)
    {
        $this->Voucher = $voucher;
        return $this;
    }
    /**
     * Get LoyaltyRedemption value
     * @return \Sabre\OTAPing\Structs\LoyaltyRedemption|null
     */
    public function getLoyaltyRedemption()
    {
        return $this->LoyaltyRedemption;
    }
    /**
     * Set LoyaltyRedemption value
     * @param \Sabre\OTAPing\Structs\LoyaltyRedemption $loyaltyRedemption
     * @return \Sabre\OTAPing\Structs\PaymentFormType
     */
    public function setLoyaltyRedemption(\Sabre\OTAPing\Structs\LoyaltyRedemption $loyaltyRedemption = null)
    {
        $this->LoyaltyRedemption = $loyaltyRedemption;
        return $this;
    }
    /**
     * Get MiscChargeOrder value
     * @return \Sabre\OTAPing\Structs\MiscChargeOrder|null
     */
    public function getMiscChargeOrder()
    {
        return $this->MiscChargeOrder;
    }
    /**
     * Set MiscChargeOrder value
     * @param \Sabre\OTAPing\Structs\MiscChargeOrder $miscChargeOrder
     * @return \Sabre\OTAPing\Structs\PaymentFormType
     */
    public function setMiscChargeOrder(\Sabre\OTAPing\Structs\MiscChargeOrder $miscChargeOrder = null)
    {
        $this->MiscChargeOrder = $miscChargeOrder;
        return $this;
    }
    /**
     * Get Ticket value
     * @return \Sabre\OTAPing\Structs\Ticket|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param \Sabre\OTAPing\Structs\Ticket $ticket
     * @return \Sabre\OTAPing\Structs\PaymentFormType
     */
    public function setTicket(\Sabre\OTAPing\Structs\Ticket $ticket = null)
    {
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get Cash value
     * @return \Sabre\OTAPing\Structs\Cash|null
     */
    public function getCash()
    {
        return $this->Cash;
    }
    /**
     * Set Cash value
     * @param \Sabre\OTAPing\Structs\Cash $cash
     * @return \Sabre\OTAPing\Structs\PaymentFormType
     */
    public function setCash(\Sabre\OTAPing\Structs\Cash $cash = null)
    {
        $this->Cash = $cash;
        return $this;
    }
    /**
     * Get CostCenterID value
     * @return string|null
     */
    public function getCostCenterID()
    {
        return $this->CostCenterID;
    }
    /**
     * Set CostCenterID value
     * @param string $costCenterID
     * @return \Sabre\OTAPing\Structs\PaymentFormType
     */
    public function setCostCenterID($costCenterID = null)
    {
        $this->CostCenterID = $costCenterID;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\OTAPing\Structs\PaymentFormType
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get PaymentTransactionTypeCode value
     * @return string|null
     */
    public function getPaymentTransactionTypeCode()
    {
        return $this->PaymentTransactionTypeCode;
    }
    /**
     * Set PaymentTransactionTypeCode value
     * @param string $paymentTransactionTypeCode
     * @return \Sabre\OTAPing\Structs\PaymentFormType
     */
    public function setPaymentTransactionTypeCode($paymentTransactionTypeCode = null)
    {
        $this->PaymentTransactionTypeCode = $paymentTransactionTypeCode;
        return $this;
    }
    /**
     * Get GuaranteeIndicator value
     * @return bool|null
     */
    public function getGuaranteeIndicator()
    {
        return $this->GuaranteeIndicator;
    }
    /**
     * Set GuaranteeIndicator value
     * @param bool $guaranteeIndicator
     * @return \Sabre\OTAPing\Structs\PaymentFormType
     */
    public function setGuaranteeIndicator($guaranteeIndicator = null)
    {
        $this->GuaranteeIndicator = $guaranteeIndicator;
        return $this;
    }
    /**
     * Get GuaranteeTypeCode value
     * @return string|null
     */
    public function getGuaranteeTypeCode()
    {
        return $this->GuaranteeTypeCode;
    }
    /**
     * Set GuaranteeTypeCode value
     * @param string $guaranteeTypeCode
     * @return \Sabre\OTAPing\Structs\PaymentFormType
     */
    public function setGuaranteeTypeCode($guaranteeTypeCode = null)
    {
        $this->GuaranteeTypeCode = $guaranteeTypeCode;
        return $this;
    }
    /**
     * Get GuaranteeID value
     * @return string|null
     */
    public function getGuaranteeID()
    {
        return $this->GuaranteeID;
    }
    /**
     * Set GuaranteeID value
     * @param string $guaranteeID
     * @return \Sabre\OTAPing\Structs\PaymentFormType
     */
    public function setGuaranteeID($guaranteeID = null)
    {
        $this->GuaranteeID = $guaranteeID;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \Sabre\OTAPing\Structs\PaymentFormType
     */
    public function setRemark($remark = null)
    {
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\PaymentFormType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
