<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrdersType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Provides the details of one or more orders.
 * @subpackage Structs
 */
class OrdersType extends AbstractStructBase
{
    /**
     * The Order
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\Order[]
     */
    public $Order;
    /**
     * The OrderType
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the type of orders.
     * - use: optional
     * @var string
     */
    public $OrderType;
    /**
     * The DiscountCode
     * Meta informations extracted from the WSDL
     * - documentation: A discount code that applies to the orders.
     * - use: optional
     * @var string
     */
    public $DiscountCode;
    /**
     * The VendorPurchaseOrderID
     * Meta informations extracted from the WSDL
     * - documentation: The purchase order number of a sales intermediary.
     * - use: optional
     * @var string
     */
    public $VendorPurchaseOrderID;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - documentation: The identification number associated to the orders.
     * - use: optional
     * @var string
     */
    public $OrderID;
    /**
     * Constructor method for OrdersType
     * @uses OrdersType::setOrder()
     * @uses OrdersType::setOrderType()
     * @uses OrdersType::setDiscountCode()
     * @uses OrdersType::setVendorPurchaseOrderID()
     * @uses OrdersType::setOrderID()
     * @param \Sabre\OTAPing\Structs\Order[] $order
     * @param string $orderType
     * @param string $discountCode
     * @param string $vendorPurchaseOrderID
     * @param string $orderID
     */
    public function __construct(array $order = array(), $orderType = null, $discountCode = null, $vendorPurchaseOrderID = null, $orderID = null)
    {
        $this
            ->setOrder($order)
            ->setOrderType($orderType)
            ->setDiscountCode($discountCode)
            ->setVendorPurchaseOrderID($vendorPurchaseOrderID)
            ->setOrderID($orderID);
    }
    /**
     * Get Order value
     * @return \Sabre\OTAPing\Structs\Order[]|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\Order[] $order
     * @return \Sabre\OTAPing\Structs\OrdersType
     */
    public function setOrder(array $order = array())
    {
        $this->Order = $order;
        return $this;
    }
    /**
     * Add item to Order value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\Order $item
     * @return \Sabre\OTAPing\Structs\OrdersType
     */
    public function addToOrder(\Sabre\OTAPing\Structs\Order $item)
    {
        $this->Order[] = $item;
        return $this;
    }
    /**
     * Get OrderType value
     * @return string|null
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @param string $orderType
     * @return \Sabre\OTAPing\Structs\OrdersType
     */
    public function setOrderType($orderType = null)
    {
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param string $discountCode
     * @return \Sabre\OTAPing\Structs\OrdersType
     */
    public function setDiscountCode($discountCode = null)
    {
        $this->DiscountCode = $discountCode;
        return $this;
    }
    /**
     * Get VendorPurchaseOrderID value
     * @return string|null
     */
    public function getVendorPurchaseOrderID()
    {
        return $this->VendorPurchaseOrderID;
    }
    /**
     * Set VendorPurchaseOrderID value
     * @param string $vendorPurchaseOrderID
     * @return \Sabre\OTAPing\Structs\OrdersType
     */
    public function setVendorPurchaseOrderID($vendorPurchaseOrderID = null)
    {
        $this->VendorPurchaseOrderID = $vendorPurchaseOrderID;
        return $this;
    }
    /**
     * Get OrderID value
     * @return string|null
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \Sabre\OTAPing\Structs\OrdersType
     */
    public function setOrderID($orderID = null)
    {
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\OrdersType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
