<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageItemsType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Collection of image items.
 * @subpackage Structs
 */
class ImageItemsType extends AbstractStructBase
{
    /**
     * The ImageItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\OTAPing\Structs\ImageItem[]
     */
    public $ImageItem;
    /**
     * Constructor method for ImageItemsType
     * @uses ImageItemsType::setImageItem()
     * @param \Sabre\OTAPing\Structs\ImageItem[] $imageItem
     */
    public function __construct(array $imageItem = array())
    {
        $this
            ->setImageItem($imageItem);
    }
    /**
     * Get ImageItem value
     * @return \Sabre\OTAPing\Structs\ImageItem[]|null
     */
    public function getImageItem()
    {
        return $this->ImageItem;
    }
    /**
     * Set ImageItem value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\ImageItem[] $imageItem
     * @return \Sabre\OTAPing\Structs\ImageItemsType
     */
    public function setImageItem(array $imageItem = array())
    {
        $this->ImageItem = $imageItem;
        return $this;
    }
    /**
     * Add item to ImageItem value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\ImageItem $item
     * @return \Sabre\OTAPing\Structs\ImageItemsType
     */
    public function addToImageItem(\Sabre\OTAPing\Structs\ImageItem $item)
    {
        $this->ImageItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\ImageItemsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
