<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Description Structs
 * Meta informations extracted from the WSDL
 * - documentation: The description associated with the image in a specific language. | The text in a specific language.
 * - type: xs:string
 * - use: optional
 * @subpackage Structs
 */
class Description extends FormattedTextTextType
{
    /**
     * The lang
     * Meta informations extracted from the WSDL
     * - ref: xml:lang
     * - use: required
     * @var string
     */
    public $lang;
    /**
     * The Caption
     * Meta informations extracted from the WSDL
     * - documentation: The caption associated to a specific image category which can be provided in different languages.
     * - use: optional
     * @var string
     */
    public $Caption;
    /**
     * The ListItem
     * Meta informations extracted from the WSDL
     * - documentation: Sequence number associated with this description.
     * - use: optional
     * @var int
     */
    public $ListItem;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * Constructor method for Description
     * @uses Description::setLang()
     * @uses Description::setCaption()
     * @uses Description::setListItem()
     * @uses Description::set_()
     * @param string $lang
     * @param string $caption
     * @param int $listItem
     * @param string $_
     */
    public function __construct($lang = null, $caption = null, $listItem = null, $_ = null)
    {
        $this
            ->setLang($lang)
            ->setCaption($caption)
            ->setListItem($listItem)
            ->set_($_);
    }
    /**
     * Get lang value
     * @return string
     */
    public function getLang()
    {
        return $this->lang;
    }
    /**
     * Set lang value
     * @param string $lang
     * @return \Sabre\OTAPing\Structs\Description
     */
    public function setLang($lang = null)
    {
        $this->lang = $lang;
        return $this;
    }
    /**
     * Get Caption value
     * @return string|null
     */
    public function getCaption()
    {
        return $this->Caption;
    }
    /**
     * Set Caption value
     * @param string $caption
     * @return \Sabre\OTAPing\Structs\Description
     */
    public function setCaption($caption = null)
    {
        $this->Caption = $caption;
        return $this;
    }
    /**
     * Get ListItem value
     * @return int|null
     */
    public function getListItem()
    {
        return $this->ListItem;
    }
    /**
     * Set ListItem value
     * @param int $listItem
     * @return \Sabre\OTAPing\Structs\Description
     */
    public function setListItem($listItem = null)
    {
        $this->ListItem = $listItem;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\OTAPing\Structs\Description
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\Description
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
