<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionType Structs
 * Meta informations extracted from the WSDL
 * - documentation: To specify connection locations, preference level for each, min connection time, and whether location is specified for stopping or changing.
 * @subpackage Structs
 */
class ConnectionType extends AbstractStructBase
{
    /**
     * The ConnectionLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 9
     * @var \Sabre\OTAPing\Structs\ConnectionLocation[]
     */
    public $ConnectionLocation;
    /**
     * Constructor method for ConnectionType
     * @uses ConnectionType::setConnectionLocation()
     * @param \Sabre\OTAPing\Structs\ConnectionLocation[] $connectionLocation
     */
    public function __construct(array $connectionLocation = array())
    {
        $this
            ->setConnectionLocation($connectionLocation);
    }
    /**
     * Get ConnectionLocation value
     * @return \Sabre\OTAPing\Structs\ConnectionLocation[]|null
     */
    public function getConnectionLocation()
    {
        return $this->ConnectionLocation;
    }
    /**
     * Set ConnectionLocation value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\ConnectionLocation[] $connectionLocation
     * @return \Sabre\OTAPing\Structs\ConnectionType
     */
    public function setConnectionLocation(array $connectionLocation = array())
    {
        $this->ConnectionLocation = $connectionLocation;
        return $this;
    }
    /**
     * Add item to ConnectionLocation value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\ConnectionLocation $item
     * @return \Sabre\OTAPing\Structs\ConnectionType
     */
    public function addToConnectionLocation(\Sabre\OTAPing\Structs\ConnectionLocation $item)
    {
        $this->ConnectionLocation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\ConnectionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
