<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address Structs
 * Meta informations extracted from the WSDL
 * - documentation: Detailed information on an address for the customer. | The first and last dates between which this address is in effect. | Uses any part of address information, such as street name, postal code, or country code.
 * @subpackage Structs
 */
class Address extends AddressType
{
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - documentation: Identifies a company.
     * - minOccurs: 0
     * @var mixed
     */
    public $CompanyName;
    /**
     * The AddresseeName
     * Meta informations extracted from the WSDL
     * - documentation: Name of the person to whom this address relates.
     * - minOccurs: 0
     * @var mixed
     */
    public $AddresseeName;
    /**
     * The ValidationStatus
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ValidationStatus;
    /**
     * The TransferAction
     * Meta informations extracted from the WSDL
     * - documentation: Indicates under what conditions the element will be transfered to the booking.
     * - use: optional
     * @var string
     */
    public $TransferAction;
    /**
     * The ParentCompanyRef
     * Meta informations extracted from the WSDL
     * - documentation: A reference to the company from which this element has been inherited.
     * - use: optional
     * @var string
     */
    public $ParentCompanyRef;
    /**
     * The SameCountryInd
     * Meta informations extracted from the WSDL
     * - documentation: When true, only locations in the same country as the specified city's country should be selected.
     * - use: optional
     * @var bool
     */
    public $SameCountryInd;
    /**
     * The AddressSearchScope
     * @var string
     */
    public $AddressSearchScope;
    /**
     * Constructor method for Address
     * @uses Address::setCompanyName()
     * @uses Address::setAddresseeName()
     * @uses Address::setValidationStatus()
     * @uses Address::setTransferAction()
     * @uses Address::setParentCompanyRef()
     * @uses Address::setSameCountryInd()
     * @uses Address::setAddressSearchScope()
     * @param mixed $companyName
     * @param mixed $addresseeName
     * @param string $validationStatus
     * @param string $transferAction
     * @param string $parentCompanyRef
     * @param bool $sameCountryInd
     * @param string $addressSearchScope
     */
    public function __construct($companyName = null, $addresseeName = null, $validationStatus = null, $transferAction = null, $parentCompanyRef = null, $sameCountryInd = null, $addressSearchScope = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setAddresseeName($addresseeName)
            ->setValidationStatus($validationStatus)
            ->setTransferAction($transferAction)
            ->setParentCompanyRef($parentCompanyRef)
            ->setSameCountryInd($sameCountryInd)
            ->setAddressSearchScope($addressSearchScope);
    }
    /**
     * Get CompanyName value
     * @return mixed|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param mixed $companyName
     * @return \Sabre\OTAPing\Structs\Address
     */
    public function setCompanyName($companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get AddresseeName value
     * @return mixed|null
     */
    public function getAddresseeName()
    {
        return $this->AddresseeName;
    }
    /**
     * Set AddresseeName value
     * @param mixed $addresseeName
     * @return \Sabre\OTAPing\Structs\Address
     */
    public function setAddresseeName($addresseeName = null)
    {
        $this->AddresseeName = $addresseeName;
        return $this;
    }
    /**
     * Get ValidationStatus value
     * @return string|null
     */
    public function getValidationStatus()
    {
        return $this->ValidationStatus;
    }
    /**
     * Set ValidationStatus value
     * @param string $validationStatus
     * @return \Sabre\OTAPing\Structs\Address
     */
    public function setValidationStatus($validationStatus = null)
    {
        $this->ValidationStatus = $validationStatus;
        return $this;
    }
    /**
     * Get TransferAction value
     * @return string|null
     */
    public function getTransferAction()
    {
        return $this->TransferAction;
    }
    /**
     * Set TransferAction value
     * @param string $transferAction
     * @return \Sabre\OTAPing\Structs\Address
     */
    public function setTransferAction($transferAction = null)
    {
        $this->TransferAction = $transferAction;
        return $this;
    }
    /**
     * Get ParentCompanyRef value
     * @return string|null
     */
    public function getParentCompanyRef()
    {
        return $this->ParentCompanyRef;
    }
    /**
     * Set ParentCompanyRef value
     * @param string $parentCompanyRef
     * @return \Sabre\OTAPing\Structs\Address
     */
    public function setParentCompanyRef($parentCompanyRef = null)
    {
        $this->ParentCompanyRef = $parentCompanyRef;
        return $this;
    }
    /**
     * Get SameCountryInd value
     * @return bool|null
     */
    public function getSameCountryInd()
    {
        return $this->SameCountryInd;
    }
    /**
     * Set SameCountryInd value
     * @param bool $sameCountryInd
     * @return \Sabre\OTAPing\Structs\Address
     */
    public function setSameCountryInd($sameCountryInd = null)
    {
        $this->SameCountryInd = $sameCountryInd;
        return $this;
    }
    /**
     * Get AddressSearchScope value
     * @return string|null
     */
    public function getAddressSearchScope()
    {
        return $this->AddressSearchScope;
    }
    /**
     * Set AddressSearchScope value
     * @param string $addressSearchScope
     * @return \Sabre\OTAPing\Structs\Address
     */
    public function setAddressSearchScope($addressSearchScope = null)
    {
        $this->AddressSearchScope = $addressSearchScope;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
