<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptablePaymentCards Structs
 * Meta informations extracted from the WSDL
 * - documentation: A collection of payment cards that are acceptable as a form of payment.
 * @subpackage Structs
 */
class AcceptablePaymentCards extends AbstractStructBase
{
    /**
     * The AcceptablePaymentCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * @var \Sabre\OTAPing\Structs\AcceptablePaymentCard[]
     */
    public $AcceptablePaymentCard;
    /**
     * Constructor method for AcceptablePaymentCards
     * @uses AcceptablePaymentCards::setAcceptablePaymentCard()
     * @param \Sabre\OTAPing\Structs\AcceptablePaymentCard[] $acceptablePaymentCard
     */
    public function __construct(array $acceptablePaymentCard = array())
    {
        $this
            ->setAcceptablePaymentCard($acceptablePaymentCard);
    }
    /**
     * Get AcceptablePaymentCard value
     * @return \Sabre\OTAPing\Structs\AcceptablePaymentCard[]|null
     */
    public function getAcceptablePaymentCard()
    {
        return $this->AcceptablePaymentCard;
    }
    /**
     * Set AcceptablePaymentCard value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\AcceptablePaymentCard[] $acceptablePaymentCard
     * @return \Sabre\OTAPing\Structs\AcceptablePaymentCards
     */
    public function setAcceptablePaymentCard(array $acceptablePaymentCard = array())
    {
        $this->AcceptablePaymentCard = $acceptablePaymentCard;
        return $this;
    }
    /**
     * Add item to AcceptablePaymentCard value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\AcceptablePaymentCard $item
     * @return \Sabre\OTAPing\Structs\AcceptablePaymentCards
     */
    public function addToAcceptablePaymentCard(\Sabre\OTAPing\Structs\AcceptablePaymentCard $item)
    {
        $this->AcceptablePaymentCard[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\AcceptablePaymentCards
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
