<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.sabre.com/wsdl/sabreXML1.0.00/usg/OTA_PingRQ.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.sabre.com/wsdl/sabreXML1.0.00/usg/OTA_PingRQ.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Sabre\OTAPing\ClassMap::get(),
);
/**
 * Samples for OTAP ServiceType
 */
$oTAP = new \Sabre\OTAPing\Services\OTAP($options);
$oTAP->setSoapHeaderMessageHeader(new \Sabre\OTAPing\Structs\MessageHeader());
$oTAP->setSoapHeaderSecurity(new \Sabre\OTAPing\Structs\Security());
/**
 * Sample call for OTA_PingRQ operation/method
 */
if ($oTAP->OTA_PingRQ(new \Sabre\OTAPing\Structs\OTA_PingRQ()) !== false) {
    print_r($oTAP->getResult());
} else {
    print_r($oTAP->getLastError());
}
