<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextDescriptionType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Describes a text item. | Generic information about the text multimedia item.
 * @subpackage Structs
 */
class TextDescriptionType extends AbstractStructBase
{
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - documentation: The URL for a specific text item.
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\Description[]
     */
    public $Description;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the text category. Refer to OpenTravel Code list Picture Category Code (PIC).
     * - use: optional
     * @var string
     */
    public $Category;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - documentation: The language of the text item.
     * - use: optional
     * @var string
     */
    public $Language;
    /**
     * Constructor method for TextDescriptionType
     * @uses TextDescriptionType::setURL()
     * @uses TextDescriptionType::setDescription()
     * @uses TextDescriptionType::setCategory()
     * @uses TextDescriptionType::setLanguage()
     * @param string $uRL
     * @param \Sabre\OTAPing\Structs\Description[] $description
     * @param string $category
     * @param string $language
     */
    public function __construct($uRL = null, array $description = array(), $category = null, $language = null)
    {
        $this
            ->setURL($uRL)
            ->setDescription($description)
            ->setCategory($category)
            ->setLanguage($language);
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \Sabre\OTAPing\Structs\TextDescriptionType
     */
    public function setURL($uRL = null)
    {
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get Description value
     * @return \Sabre\OTAPing\Structs\Description[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\Description[] $description
     * @return \Sabre\OTAPing\Structs\TextDescriptionType
     */
    public function setDescription(array $description = array())
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\Description $item
     * @return \Sabre\OTAPing\Structs\TextDescriptionType
     */
    public function addToDescription(\Sabre\OTAPing\Structs\Description $item)
    {
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \Sabre\OTAPing\Structs\TextDescriptionType
     */
    public function setCategory($category = null)
    {
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \Sabre\OTAPing\Structs\TextDescriptionType
     */
    public function setLanguage($language = null)
    {
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\TextDescriptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
