<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialRequestType Structs
 * Meta informations extracted from the WSDL
 * - documentation: A collection of SpecialRequest objects. The collection of all special requests associated with any part of the reservation (the reservation in its entirety, one or more guests, or one or more room stays). Which special requests
 * belong to which part is determined by each object's SpecialRequestRPHs collection.
 * @subpackage Structs
 */
class SpecialRequestType extends AbstractStructBase
{
    /**
     * The SpecialRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\OTAPing\Structs\SpecialRequest[]
     */
    public $SpecialRequest;
    /**
     * Constructor method for SpecialRequestType
     * @uses SpecialRequestType::setSpecialRequest()
     * @param \Sabre\OTAPing\Structs\SpecialRequest[] $specialRequest
     */
    public function __construct(array $specialRequest = array())
    {
        $this
            ->setSpecialRequest($specialRequest);
    }
    /**
     * Get SpecialRequest value
     * @return \Sabre\OTAPing\Structs\SpecialRequest[]|null
     */
    public function getSpecialRequest()
    {
        return $this->SpecialRequest;
    }
    /**
     * Set SpecialRequest value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\SpecialRequest[] $specialRequest
     * @return \Sabre\OTAPing\Structs\SpecialRequestType
     */
    public function setSpecialRequest(array $specialRequest = array())
    {
        $this->SpecialRequest = $specialRequest;
        return $this;
    }
    /**
     * Add item to SpecialRequest value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\SpecialRequest $item
     * @return \Sabre\OTAPing\Structs\SpecialRequestType
     */
    public function addToSpecialRequest(\Sabre\OTAPing\Structs\SpecialRequest $item)
    {
        $this->SpecialRequest[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\SpecialRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
