<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Product Structs
 * Meta informations extracted from the WSDL
 * - documentation: The details associated to a specific product. | The amount related to the specific item (e.g., if the item being purchased is a gift certificate, and only one item is being purchased the full amount is applied to the gift
 * certificate).
 * @subpackage Structs
 */
class Product extends AbstractStructBase
{
    /**
     * The ProductIssueDate
     * Meta informations extracted from the WSDL
     * - documentation: The date or date and time that the product was issued.
     * - use: optional
     * @var string
     */
    public $ProductIssueDate;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - documentation: An identification number associated to the specific product.
     * - use: optional
     * @var string
     */
    public $ProductID;
    /**
     * The ProductType
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the type of product being purchased.
     * - use: optional
     * @var string
     */
    public $ProductType;
    /**
     * The ProductQuantity
     * Meta informations extracted from the WSDL
     * - documentation: The number of the specific product being purchased.
     * - use: optional
     * @var int
     */
    public $ProductQuantity;
    /**
     * The ProductSerialNumber
     * Meta informations extracted from the WSDL
     * - documentation: The serial number of the specific product.
     * - use: optional
     * @var string
     */
    public $ProductSerialNumber;
    /**
     * The DiscountCode
     * Meta informations extracted from the WSDL
     * - documentation: The discount code that applies to the specific product.
     * - use: optional
     * @var string
     */
    public $DiscountCode;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The ListOfRecipientRPH
     * Meta informations extracted from the WSDL
     * - documentation: The recipient(s) to whom the product pertains.
     * - use: optional
     * @var string
     */
    public $ListOfRecipientRPH;
    /**
     * Constructor method for Product
     * @uses Product::setProductIssueDate()
     * @uses Product::setProductID()
     * @uses Product::setProductType()
     * @uses Product::setProductQuantity()
     * @uses Product::setProductSerialNumber()
     * @uses Product::setDiscountCode()
     * @uses Product::setStatus()
     * @uses Product::setListOfRecipientRPH()
     * @param string $productIssueDate
     * @param string $productID
     * @param string $productType
     * @param int $productQuantity
     * @param string $productSerialNumber
     * @param string $discountCode
     * @param string $status
     * @param string $listOfRecipientRPH
     */
    public function __construct($productIssueDate = null, $productID = null, $productType = null, $productQuantity = null, $productSerialNumber = null, $discountCode = null, $status = null, $listOfRecipientRPH = null)
    {
        $this
            ->setProductIssueDate($productIssueDate)
            ->setProductID($productID)
            ->setProductType($productType)
            ->setProductQuantity($productQuantity)
            ->setProductSerialNumber($productSerialNumber)
            ->setDiscountCode($discountCode)
            ->setStatus($status)
            ->setListOfRecipientRPH($listOfRecipientRPH);
    }
    /**
     * Get ProductIssueDate value
     * @return string|null
     */
    public function getProductIssueDate()
    {
        return $this->ProductIssueDate;
    }
    /**
     * Set ProductIssueDate value
     * @param string $productIssueDate
     * @return \Sabre\OTAPing\Structs\Product
     */
    public function setProductIssueDate($productIssueDate = null)
    {
        $this->ProductIssueDate = $productIssueDate;
        return $this;
    }
    /**
     * Get ProductID value
     * @return string|null
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param string $productID
     * @return \Sabre\OTAPing\Structs\Product
     */
    public function setProductID($productID = null)
    {
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @param string $productType
     * @return \Sabre\OTAPing\Structs\Product
     */
    public function setProductType($productType = null)
    {
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get ProductQuantity value
     * @return int|null
     */
    public function getProductQuantity()
    {
        return $this->ProductQuantity;
    }
    /**
     * Set ProductQuantity value
     * @param int $productQuantity
     * @return \Sabre\OTAPing\Structs\Product
     */
    public function setProductQuantity($productQuantity = null)
    {
        $this->ProductQuantity = $productQuantity;
        return $this;
    }
    /**
     * Get ProductSerialNumber value
     * @return string|null
     */
    public function getProductSerialNumber()
    {
        return $this->ProductSerialNumber;
    }
    /**
     * Set ProductSerialNumber value
     * @param string $productSerialNumber
     * @return \Sabre\OTAPing\Structs\Product
     */
    public function setProductSerialNumber($productSerialNumber = null)
    {
        $this->ProductSerialNumber = $productSerialNumber;
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param string $discountCode
     * @return \Sabre\OTAPing\Structs\Product
     */
    public function setDiscountCode($discountCode = null)
    {
        $this->DiscountCode = $discountCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\OTAPing\Structs\Product
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ListOfRecipientRPH value
     * @return string|null
     */
    public function getListOfRecipientRPH()
    {
        return $this->ListOfRecipientRPH;
    }
    /**
     * Set ListOfRecipientRPH value
     * @param string $listOfRecipientRPH
     * @return \Sabre\OTAPing\Structs\Product
     */
    public function setListOfRecipientRPH($listOfRecipientRPH = null)
    {
        $this->ListOfRecipientRPH = $listOfRecipientRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\Product
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
