<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonNameType Structs
 * Meta informations extracted from the WSDL
 * - documentation: This provides name information for a person. | Allows for control of the sharing of person name data between parties.
 * @subpackage Structs
 */
class PersonNameType extends AbstractStructBase
{
    /**
     * The NamePrefix
     * Meta informations extracted from the WSDL
     * - documentation: Salutation of honorific (e.g. Mr., Mrs., Ms., Miss, Dr.)
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var mixed[]
     */
    public $NamePrefix;
    /**
     * The GivenName
     * Meta informations extracted from the WSDL
     * - documentation: Given name, first name or names.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $GivenName;
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - documentation: The middle name of the person name.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var mixed[]
     */
    public $MiddleName;
    /**
     * The SurnamePrefix
     * Meta informations extracted from the WSDL
     * - documentation: e.g "van der", "von", "de".
     * - minOccurs: 0
     * @var mixed
     */
    public $SurnamePrefix;
    /**
     * The Surname
     * Meta informations extracted from the WSDL
     * - documentation: Family name, last name. May also be used for full name if the sending system does not have the ability to separate a full name into its parts, e.g. the surname element may be used to pass the full name.
     * @var mixed
     */
    public $Surname;
    /**
     * The NameSuffix
     * Meta informations extracted from the WSDL
     * - documentation: Hold various name suffixes and letters (e.g. Jr., Sr., III, Ret., Esq.)
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var mixed[]
     */
    public $NameSuffix;
    /**
     * The NameTitle
     * Meta informations extracted from the WSDL
     * - documentation: Degree or honors (e.g., Ph.D., M.D.)
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $NameTitle;
    /**
     * The NameType
     * Meta informations extracted from the WSDL
     * - documentation: Type of name of the individual, such as former, nickname, alternate or alias name. Refer to OpenTravel Code List Name Type (NAM).
     * - use: optional
     * @var string
     */
    public $NameType;
    /**
     * Constructor method for PersonNameType
     * @uses PersonNameType::setNamePrefix()
     * @uses PersonNameType::setGivenName()
     * @uses PersonNameType::setMiddleName()
     * @uses PersonNameType::setSurnamePrefix()
     * @uses PersonNameType::setSurname()
     * @uses PersonNameType::setNameSuffix()
     * @uses PersonNameType::setNameTitle()
     * @uses PersonNameType::setNameType()
     * @param mixed[] $namePrefix
     * @param mixed[] $givenName
     * @param mixed[] $middleName
     * @param mixed $surnamePrefix
     * @param mixed $surname
     * @param mixed[] $nameSuffix
     * @param mixed[] $nameTitle
     * @param string $nameType
     */
    public function __construct(array $namePrefix = array(), array $givenName = array(), array $middleName = array(), $surnamePrefix = null, $surname = null, array $nameSuffix = array(), array $nameTitle = array(), $nameType = null)
    {
        $this
            ->setNamePrefix($namePrefix)
            ->setGivenName($givenName)
            ->setMiddleName($middleName)
            ->setSurnamePrefix($surnamePrefix)
            ->setSurname($surname)
            ->setNameSuffix($nameSuffix)
            ->setNameTitle($nameTitle)
            ->setNameType($nameType);
    }
    /**
     * Get NamePrefix value
     * @return mixed[]|null
     */
    public function getNamePrefix()
    {
        return $this->NamePrefix;
    }
    /**
     * Set NamePrefix value
     * @throws \InvalidArgumentException
     * @param mixed[] $namePrefix
     * @return \Sabre\OTAPing\Structs\PersonNameType
     */
    public function setNamePrefix(array $namePrefix = array())
    {
        $this->NamePrefix = $namePrefix;
        return $this;
    }
    /**
     * Add item to NamePrefix value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \Sabre\OTAPing\Structs\PersonNameType
     */
    public function addToNamePrefix($item)
    {
        $this->NamePrefix[] = $item;
        return $this;
    }
    /**
     * Get GivenName value
     * @return mixed[]|null
     */
    public function getGivenName()
    {
        return $this->GivenName;
    }
    /**
     * Set GivenName value
     * @throws \InvalidArgumentException
     * @param mixed[] $givenName
     * @return \Sabre\OTAPing\Structs\PersonNameType
     */
    public function setGivenName(array $givenName = array())
    {
        $this->GivenName = $givenName;
        return $this;
    }
    /**
     * Add item to GivenName value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \Sabre\OTAPing\Structs\PersonNameType
     */
    public function addToGivenName($item)
    {
        $this->GivenName[] = $item;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return mixed[]|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @throws \InvalidArgumentException
     * @param mixed[] $middleName
     * @return \Sabre\OTAPing\Structs\PersonNameType
     */
    public function setMiddleName(array $middleName = array())
    {
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Add item to MiddleName value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \Sabre\OTAPing\Structs\PersonNameType
     */
    public function addToMiddleName($item)
    {
        $this->MiddleName[] = $item;
        return $this;
    }
    /**
     * Get SurnamePrefix value
     * @return mixed|null
     */
    public function getSurnamePrefix()
    {
        return $this->SurnamePrefix;
    }
    /**
     * Set SurnamePrefix value
     * @param mixed $surnamePrefix
     * @return \Sabre\OTAPing\Structs\PersonNameType
     */
    public function setSurnamePrefix($surnamePrefix = null)
    {
        $this->SurnamePrefix = $surnamePrefix;
        return $this;
    }
    /**
     * Get Surname value
     * @return mixed|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param mixed $surname
     * @return \Sabre\OTAPing\Structs\PersonNameType
     */
    public function setSurname($surname = null)
    {
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get NameSuffix value
     * @return mixed[]|null
     */
    public function getNameSuffix()
    {
        return $this->NameSuffix;
    }
    /**
     * Set NameSuffix value
     * @throws \InvalidArgumentException
     * @param mixed[] $nameSuffix
     * @return \Sabre\OTAPing\Structs\PersonNameType
     */
    public function setNameSuffix(array $nameSuffix = array())
    {
        $this->NameSuffix = $nameSuffix;
        return $this;
    }
    /**
     * Add item to NameSuffix value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \Sabre\OTAPing\Structs\PersonNameType
     */
    public function addToNameSuffix($item)
    {
        $this->NameSuffix[] = $item;
        return $this;
    }
    /**
     * Get NameTitle value
     * @return mixed[]|null
     */
    public function getNameTitle()
    {
        return $this->NameTitle;
    }
    /**
     * Set NameTitle value
     * @throws \InvalidArgumentException
     * @param mixed[] $nameTitle
     * @return \Sabre\OTAPing\Structs\PersonNameType
     */
    public function setNameTitle(array $nameTitle = array())
    {
        $this->NameTitle = $nameTitle;
        return $this;
    }
    /**
     * Add item to NameTitle value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \Sabre\OTAPing\Structs\PersonNameType
     */
    public function addToNameTitle($item)
    {
        $this->NameTitle[] = $item;
        return $this;
    }
    /**
     * Get NameType value
     * @return string|null
     */
    public function getNameType()
    {
        return $this->NameType;
    }
    /**
     * Set NameType value
     * @param string $nameType
     * @return \Sabre\OTAPing\Structs\PersonNameType
     */
    public function setNameType($nameType = null)
    {
        $this->NameType = $nameType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\PersonNameType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
