<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoyaltyRedemption Structs
 * Meta informations extracted from the WSDL
 * - documentation: Details of a loyalty redemption arrangement. This is normally miles or points. | Identifies the Loyalty scheme, programs and promotions within the scheme, membership reference, form factor used by the certificate, the number of
 * nights it can be used for and its current status. | Used to provide a promotion code of the loyalty redemption.
 * @subpackage Structs
 */
class LoyaltyRedemption extends AbstractStructBase
{
    /**
     * The LoyaltyCertificate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\LoyaltyCertificate[]
     */
    public $LoyaltyCertificate;
    /**
     * The RedemptionQuantity
     * Meta informations extracted from the WSDL
     * - documentation: The quantity of loyalty units being redeemed.
     * - use: optional
     * @var int
     */
    public $RedemptionQuantity;
    /**
     * Constructor method for LoyaltyRedemption
     * @uses LoyaltyRedemption::setLoyaltyCertificate()
     * @uses LoyaltyRedemption::setRedemptionQuantity()
     * @param \Sabre\OTAPing\Structs\LoyaltyCertificate[] $loyaltyCertificate
     * @param int $redemptionQuantity
     */
    public function __construct(array $loyaltyCertificate = array(), $redemptionQuantity = null)
    {
        $this
            ->setLoyaltyCertificate($loyaltyCertificate)
            ->setRedemptionQuantity($redemptionQuantity);
    }
    /**
     * Get LoyaltyCertificate value
     * @return \Sabre\OTAPing\Structs\LoyaltyCertificate[]|null
     */
    public function getLoyaltyCertificate()
    {
        return $this->LoyaltyCertificate;
    }
    /**
     * Set LoyaltyCertificate value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\LoyaltyCertificate[] $loyaltyCertificate
     * @return \Sabre\OTAPing\Structs\LoyaltyRedemption
     */
    public function setLoyaltyCertificate(array $loyaltyCertificate = array())
    {
        $this->LoyaltyCertificate = $loyaltyCertificate;
        return $this;
    }
    /**
     * Add item to LoyaltyCertificate value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\LoyaltyCertificate $item
     * @return \Sabre\OTAPing\Structs\LoyaltyRedemption
     */
    public function addToLoyaltyCertificate(\Sabre\OTAPing\Structs\LoyaltyCertificate $item)
    {
        $this->LoyaltyCertificate[] = $item;
        return $this;
    }
    /**
     * Get RedemptionQuantity value
     * @return int|null
     */
    public function getRedemptionQuantity()
    {
        return $this->RedemptionQuantity;
    }
    /**
     * Set RedemptionQuantity value
     * @param int $redemptionQuantity
     * @return \Sabre\OTAPing\Structs\LoyaltyRedemption
     */
    public function setRedemptionQuantity($redemptionQuantity = null)
    {
        $this->RedemptionQuantity = $redemptionQuantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\LoyaltyRedemption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
