<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EquipmentType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Specifies the aircraft equipment type. | Used for Character Strings, length 0 to 64.
 * - maxLength: 64
 * - minLength: 0
 * @subpackage Structs
 */
class EquipmentType extends AbstractStructBase
{
    /**
     * The AirEquipType
     * Meta informations extracted from the WSDL
     * - documentation: This is the 3 character IATA code.
     * - use: optional
     * @var string
     */
    public $AirEquipType;
    /**
     * The ChangeofGauge
     * Meta informations extracted from the WSDL
     * - documentation: Indicates there is an equipment change. | false
     * - use: optional
     * @var bool
     */
    public $ChangeofGauge;
    /**
     * Constructor method for EquipmentType
     * @uses EquipmentType::setAirEquipType()
     * @uses EquipmentType::setChangeofGauge()
     * @param string $airEquipType
     * @param bool $changeofGauge
     */
    public function __construct($airEquipType = null, $changeofGauge = null)
    {
        $this
            ->setAirEquipType($airEquipType)
            ->setChangeofGauge($changeofGauge);
    }
    /**
     * Get AirEquipType value
     * @return string|null
     */
    public function getAirEquipType()
    {
        return $this->AirEquipType;
    }
    /**
     * Set AirEquipType value
     * @param string $airEquipType
     * @return \Sabre\OTAPing\Structs\EquipmentType
     */
    public function setAirEquipType($airEquipType = null)
    {
        $this->AirEquipType = $airEquipType;
        return $this;
    }
    /**
     * Get ChangeofGauge value
     * @return bool|null
     */
    public function getChangeofGauge()
    {
        return $this->ChangeofGauge;
    }
    /**
     * Set ChangeofGauge value
     * @param bool $changeofGauge
     * @return \Sabre\OTAPing\Structs\EquipmentType
     */
    public function setChangeofGauge($changeofGauge = null)
    {
        $this->ChangeofGauge = $changeofGauge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\EquipmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
