<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustLoyalty Structs
 * Meta informations extracted from the WSDL
 * - documentation: Loyalty program information for the customer. | Program rewarding frequent use by accumulating credits for services provided by vendors. | Customer loyalty information used for additional authorization checks. | Customer loyalty
 * information. | Loyalty program information. | Details of the customer loyalty membership.
 * @subpackage Structs
 */
class CustLoyalty extends AbstractStructBase
{
    /**
     * The Remark
     * Meta informations extracted from the WSDL
     * - documentation: A remark associated with the customer's loyalty program.
     * - use: optional
     * @var string
     */
    public $Remark;
    /**
     * Constructor method for CustLoyalty
     * @uses CustLoyalty::setRemark()
     * @param string $remark
     */
    public function __construct($remark = null)
    {
        $this
            ->setRemark($remark);
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \Sabre\OTAPing\Structs\CustLoyalty
     */
    public function setRemark($remark = null)
    {
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\CustLoyalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
