<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Comment Structs
 * Meta informations extracted from the WSDL
 * - documentation: Comment details.
 * @subpackage Structs
 */
class Comment extends ParagraphType
{
    /**
     * The CommentOriginatorCode
     * Meta informations extracted from the WSDL
     * - documentation: Unique identifier for the system which created the comment.
     * - use: optional
     * @var string
     */
    public $CommentOriginatorCode;
    /**
     * The GuestViewable
     * Meta informations extracted from the WSDL
     * - documentation: When true, the comment may be shown to the consumer. When false, the comment may not be shown to the consumer.
     * - use: optional
     * @var bool
     */
    public $GuestViewable;
    /**
     * Constructor method for Comment
     * @uses Comment::setCommentOriginatorCode()
     * @uses Comment::setGuestViewable()
     * @param string $commentOriginatorCode
     * @param bool $guestViewable
     */
    public function __construct($commentOriginatorCode = null, $guestViewable = null)
    {
        $this
            ->setCommentOriginatorCode($commentOriginatorCode)
            ->setGuestViewable($guestViewable);
    }
    /**
     * Get CommentOriginatorCode value
     * @return string|null
     */
    public function getCommentOriginatorCode()
    {
        return $this->CommentOriginatorCode;
    }
    /**
     * Set CommentOriginatorCode value
     * @param string $commentOriginatorCode
     * @return \Sabre\OTAPing\Structs\Comment
     */
    public function setCommentOriginatorCode($commentOriginatorCode = null)
    {
        $this->CommentOriginatorCode = $commentOriginatorCode;
        return $this;
    }
    /**
     * Get GuestViewable value
     * @return bool|null
     */
    public function getGuestViewable()
    {
        return $this->GuestViewable;
    }
    /**
     * Set GuestViewable value
     * @param bool $guestViewable
     * @return \Sabre\OTAPing\Structs\Comment
     */
    public function setGuestViewable($guestViewable = null)
    {
        $this->GuestViewable = $guestViewable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\Comment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
