<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticket Structs
 * Meta informations extracted from the WSDL
 * - documentation: Details of a ticket to be exchanged.
 * @subpackage Structs
 */
class Ticket extends AbstractStructBase
{
    /**
     * The ConjunctionTicketNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 16
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\ConjunctionTicketNbr[]
     */
    public $ConjunctionTicketNbr;
    /**
     * The TicketNumber
     * Meta informations extracted from the WSDL
     * - documentation: The ticket number which is exchanged.
     * @var string
     */
    public $TicketNumber;
    /**
     * The ReroutingType
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ReroutingType;
    /**
     * The ReasonForReroute
     * Meta informations extracted from the WSDL
     * - documentation: Gives more information about the rerouting.
     * - use: optional
     * @var string
     */
    public $ReasonForReroute;
    /**
     * Constructor method for Ticket
     * @uses Ticket::setConjunctionTicketNbr()
     * @uses Ticket::setTicketNumber()
     * @uses Ticket::setReroutingType()
     * @uses Ticket::setReasonForReroute()
     * @param \Sabre\OTAPing\Structs\ConjunctionTicketNbr[] $conjunctionTicketNbr
     * @param string $ticketNumber
     * @param string $reroutingType
     * @param string $reasonForReroute
     */
    public function __construct(array $conjunctionTicketNbr = array(), $ticketNumber = null, $reroutingType = null, $reasonForReroute = null)
    {
        $this
            ->setConjunctionTicketNbr($conjunctionTicketNbr)
            ->setTicketNumber($ticketNumber)
            ->setReroutingType($reroutingType)
            ->setReasonForReroute($reasonForReroute);
    }
    /**
     * Get ConjunctionTicketNbr value
     * @return \Sabre\OTAPing\Structs\ConjunctionTicketNbr[]|null
     */
    public function getConjunctionTicketNbr()
    {
        return $this->ConjunctionTicketNbr;
    }
    /**
     * Set ConjunctionTicketNbr value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\ConjunctionTicketNbr[] $conjunctionTicketNbr
     * @return \Sabre\OTAPing\Structs\Ticket
     */
    public function setConjunctionTicketNbr(array $conjunctionTicketNbr = array())
    {
        $this->ConjunctionTicketNbr = $conjunctionTicketNbr;
        return $this;
    }
    /**
     * Add item to ConjunctionTicketNbr value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\ConjunctionTicketNbr $item
     * @return \Sabre\OTAPing\Structs\Ticket
     */
    public function addToConjunctionTicketNbr(\Sabre\OTAPing\Structs\ConjunctionTicketNbr $item)
    {
        $this->ConjunctionTicketNbr[] = $item;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return string|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param string $ticketNumber
     * @return \Sabre\OTAPing\Structs\Ticket
     */
    public function setTicketNumber($ticketNumber = null)
    {
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Get ReroutingType value
     * @return string|null
     */
    public function getReroutingType()
    {
        return $this->ReroutingType;
    }
    /**
     * Set ReroutingType value
     * @param string $reroutingType
     * @return \Sabre\OTAPing\Structs\Ticket
     */
    public function setReroutingType($reroutingType = null)
    {
        $this->ReroutingType = $reroutingType;
        return $this;
    }
    /**
     * Get ReasonForReroute value
     * @return string|null
     */
    public function getReasonForReroute()
    {
        return $this->ReasonForReroute;
    }
    /**
     * Set ReasonForReroute value
     * @param string $reasonForReroute
     * @return \Sabre\OTAPing\Structs\Ticket
     */
    public function setReasonForReroute($reasonForReroute = null)
    {
        $this->ReasonForReroute = $reasonForReroute;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\Ticket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
