<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextItem Structs
 * Meta informations extracted from the WSDL
 * - documentation: Text description of a given category. | Creation and modification information for this text item. | If true, this item is obsolete and should be removed from the receiving system.
 * @subpackage Structs
 */
class TextItem extends TextDescriptionType
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - documentation: The version of the text item.
     * - use: optional
     * @var string
     */
    public $Version;
    /**
     * Constructor method for TextItem
     * @uses TextItem::setVersion()
     * @param string $version
     */
    public function __construct($version = null)
    {
        $this
            ->setVersion($version);
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Sabre\OTAPing\Structs\TextItem
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\TextItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
