<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefPoint Structs
 * Meta informations extracted from the WSDL
 * - documentation: The Reference Point element allows for a search by proximity to a designated reference point by name. | Used to specify a reference point by a code. | Used for Character Strings, length 0 to 64.
 * - maxLength: 64
 * - minLength: 0
 * @subpackage Structs
 */
class RefPoint extends AbstractStructBase
{
    /**
     * The StateProv
     * Meta informations extracted from the WSDL
     * - documentation: The state or province in which the reference point is located.
     * - use: optional
     * @var string
     */
    public $StateProv;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - documentation: The country in which the reference point is located.
     * - use: optional
     * @var string
     */
    public $CountryCode;
    /**
     * The RefPointType
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the type of location being referenced (e.g., Airport, Hotel). Refer to the OpenTravel Code table Index Point Code (IPC).
     * - use: optional
     * @var string
     */
    public $RefPointType;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: The name of the reference point.
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The CityName
     * Meta informations extracted from the WSDL
     * - documentation: The name of the city associated with this reference point.
     * - use: optional
     * @var string
     */
    public $CityName;
    /**
     * Constructor method for RefPoint
     * @uses RefPoint::setStateProv()
     * @uses RefPoint::setCountryCode()
     * @uses RefPoint::setRefPointType()
     * @uses RefPoint::setName()
     * @uses RefPoint::setCityName()
     * @param string $stateProv
     * @param string $countryCode
     * @param string $refPointType
     * @param string $name
     * @param string $cityName
     */
    public function __construct($stateProv = null, $countryCode = null, $refPointType = null, $name = null, $cityName = null)
    {
        $this
            ->setStateProv($stateProv)
            ->setCountryCode($countryCode)
            ->setRefPointType($refPointType)
            ->setName($name)
            ->setCityName($cityName);
    }
    /**
     * Get StateProv value
     * @return string|null
     */
    public function getStateProv()
    {
        return $this->StateProv;
    }
    /**
     * Set StateProv value
     * @param string $stateProv
     * @return \Sabre\OTAPing\Structs\RefPoint
     */
    public function setStateProv($stateProv = null)
    {
        $this->StateProv = $stateProv;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \Sabre\OTAPing\Structs\RefPoint
     */
    public function setCountryCode($countryCode = null)
    {
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get RefPointType value
     * @return string|null
     */
    public function getRefPointType()
    {
        return $this->RefPointType;
    }
    /**
     * Set RefPointType value
     * @param string $refPointType
     * @return \Sabre\OTAPing\Structs\RefPoint
     */
    public function setRefPointType($refPointType = null)
    {
        $this->RefPointType = $refPointType;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\OTAPing\Structs\RefPoint
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \Sabre\OTAPing\Structs\RefPoint
     */
    public function setCityName($cityName = null)
    {
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\RefPoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
