<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecipientInfo Structs
 * Meta informations extracted from the WSDL
 * - documentation: Contact and/or reservation information pertaining to the recipient.
 * @subpackage Structs
 */
class RecipientInfo extends ContactPersonType
{
    /**
     * The ReservationID
     * Meta informations extracted from the WSDL
     * - documentation: Provides the reservation number of the recipient for delivery of the product.
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var mixed[]
     */
    public $ReservationID;
    /**
     * The ShippingInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\ShippingInfo
     */
    public $ShippingInfo;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\Comments
     */
    public $Comments;
    /**
     * Constructor method for RecipientInfo
     * @uses RecipientInfo::setReservationID()
     * @uses RecipientInfo::setShippingInfo()
     * @uses RecipientInfo::setComments()
     * @param mixed[] $reservationID
     * @param \Sabre\OTAPing\Structs\ShippingInfo $shippingInfo
     * @param \Sabre\OTAPing\Structs\Comments $comments
     */
    public function __construct(array $reservationID = array(), \Sabre\OTAPing\Structs\ShippingInfo $shippingInfo = null, \Sabre\OTAPing\Structs\Comments $comments = null)
    {
        $this
            ->setReservationID($reservationID)
            ->setShippingInfo($shippingInfo)
            ->setComments($comments);
    }
    /**
     * Get ReservationID value
     * @return mixed[]|null
     */
    public function getReservationID()
    {
        return $this->ReservationID;
    }
    /**
     * Set ReservationID value
     * @throws \InvalidArgumentException
     * @param mixed[] $reservationID
     * @return \Sabre\OTAPing\Structs\RecipientInfo
     */
    public function setReservationID(array $reservationID = array())
    {
        $this->ReservationID = $reservationID;
        return $this;
    }
    /**
     * Add item to ReservationID value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \Sabre\OTAPing\Structs\RecipientInfo
     */
    public function addToReservationID($item)
    {
        $this->ReservationID[] = $item;
        return $this;
    }
    /**
     * Get ShippingInfo value
     * @return \Sabre\OTAPing\Structs\ShippingInfo|null
     */
    public function getShippingInfo()
    {
        return $this->ShippingInfo;
    }
    /**
     * Set ShippingInfo value
     * @param \Sabre\OTAPing\Structs\ShippingInfo $shippingInfo
     * @return \Sabre\OTAPing\Structs\RecipientInfo
     */
    public function setShippingInfo(\Sabre\OTAPing\Structs\ShippingInfo $shippingInfo = null)
    {
        $this->ShippingInfo = $shippingInfo;
        return $this;
    }
    /**
     * Get Comments value
     * @return \Sabre\OTAPing\Structs\Comments|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \Sabre\OTAPing\Structs\Comments $comments
     * @return \Sabre\OTAPing\Structs\RecipientInfo
     */
    public function setComments(\Sabre\OTAPing\Structs\Comments $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\RecipientInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
